<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Imports the sudoku database.
 *
 * @package    mod_game
 * @copyright  2007 Vasilis Daloukas
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26, ".
    "'A73IEDB8642I16875CF85237A94539712D6HBGFC849158415FI3G28913BE64GFDB89753175C41692H')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 29, ".
    "'E48721C9F72A36I5849C64581GBD5B96G81CF931D8BE7G81E23F49AG92H56C44C29768AEH6E31D297')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    "'5IG24F1384819376EBF23E8A4979F5CH2714813745BFI7DB9A6835HB365147957DCI8126169274CEH')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    "'52D168G3IH16C97D25973EB4816I81F732452G3E849F16452917CH4EF8A73I273B64I15HA8I352D6G')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    "'51CH462797D2931EF8F8I257D1C738965ABD254H1C679I6AG4283E6IB3814EG385D9GA261G45B63I8')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    "'2HG41E9C66D1BI3578395768A4B5I2AFC874C6G82491E4H15796BCFE1729348489A36G5B237HE4I16')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    "'8G56I431223A75869DI46C127E84295FC781HA5I47C2663G8B1E9DB46A57I385H3D691G21GI2H34FE')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    "'162DCG89EI7HA56243534829G1F3GF2895418946AE73B2EA4736IH7286A4IE3CF1529487945CHG162')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    "'E79826CADBD19358676834GA2I5FDG19825C15C6247HI8293EG1647819F5432DI6312EG8E327489AF')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    "'691DE37828CB6715I44758921FCEC724H9A6249A63G85681G5IC2D82E164CGI3169BG45HIDG538B16')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    "'IDH73AF25617EB4938253689DAG586192CGD7IA45386234BHGF1954EI8132F7386BGI1457215649CH')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    "'6ED3G91B89821E46C7A73F8BI54286791EDC5GI34H2164CA26E897D6GI32H15H25G6A4933195487BF')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    "'938D6G1257465129HCAEB839764BH3519G4FA67B3D8E9ID56872138I43E2F7A3B16G849557F49A32H')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    "'74CA2I856E286D79131968354GB517498CFB2IF135784348B6GE19FH52349G137A8FI45292D7516HC')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    "'196G23H54B8CD6591757D9AH36B9CE24A6781467I83EB287F53A49417EF9382E2I8346GAHC67214I5')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    "'1DC825796692734EAH875AIF342F5IB384713BG46A98548AG592FC5623HD9A78G3159BD6I14627E38')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    "'725H36DAI3H19DB7F5IF457132894158GBFC638D2I15GGEB136849C9H17265D276EI4813D15683B9G')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    "'82F17I5CD9G43FE2H113E24H76IG15C62948893D57A266B49H15G34E76H3BI163I51B74H812D97C56')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    "'46C12GH9E19285C67DHGE64I132974F1BE382F8435IA7EA39874267513H92D63D6E21G8IBIH76D351')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 23,".
    "'A56DI3872983672EA4D2G851396341528IFGH97C61425E6BI741837H9634B1E13F25I7482457AH6C9')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    "'C27561D9858DI7B16319F34875B21IF8E743CE84I72A6467B139H59C41E68GBH2573I6416G1HB4EC9')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 23,".
    "'48735I26A9BE416387613G8B54I1756C89B423457I86AH9F421375H46E13G92193GD2F582E79F8AC4')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    "'CAH7942562641E3GHI7598F21D38B5I7CD6194G61B83E63A58D92GF3IE47182521C98DG6478B16CI5')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    "'38B7E9A4F5I74F1328D61HC2795527HFD93181973EB4F6DC219578695DAH273A7B653I843849271EF')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    "'82C41IE6G619EBG8437D53861IBB78936A45DCEG81962961EBD8C7651792CHDBI8354176473F1H259')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    "'6A9HE3247D57926C8182C17495F9BD7CH165735F1I24H6H15D23I7E71382D968F21I45G3D39G65B18')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    "'FHC291754415G36HIB972E8D136DA9365872357B8I16426H741C9E9CF12G54H5286D3IG14A78596B3')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    "'91F528C7DH4E39712F237ADF589A69H52G43B34769E8175HDAC692BC54H16976A89G2453IG4365HB1')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    "'36BIEG4817IA43826E5841269GC513276HDIFG4389512892DEA3F7735698ABD8DF1BC957B1I74E638')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    "'1D5FGCB987IC2854618629143GE416E3I8B7C2H176549597D28F3A754IFB38A93B8146EGAHF753249')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    "'3981GE24F761D28C9E5DB3I6781H39D52G6117D639E8B2FEH1G4396879AC5249532478AF1BD658973')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    "'2G51496H3A3F87594B4986BC7E181F53D7923I76214EHED2H79C16I67428C51284E13GF913E9FG28D')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 29,".
    "'98547B13FCAB65H47I746C1IB5HG29H14F53864EICA27A3562GI843672I85D12H57D1936491EFC8G2')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    "'439618BEG127D5I836H56B73D19385A4BG967FD395B181I268G34E9718235FD642EG19H35C89F4721')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    "'CA9874B568F2A35DG97E4F2I38A7C86I15D25162DG9H3I4BH35A6718E46392G39472A65H2GF598413')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    "'BHG596143196HD37E2543GA2F9892836D71ECF1578924475AB93H6D79651HCB23548I61GH6A23G95D')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 22,".
    "'G12D93E685H32F7491469815CB78256D79CA63I12E87474A98C25F35418927FG1B346I586I8EG2134')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    "'821E3I7649F52D7CH1C7D186925IAH35764B524196GC8637B4H5911HC2G649545I81367B762DE98A3')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    "'92E7FA384C4GE8B9168A63495G2FD32185GI1I5GC462872H69E13DH9G456A3245A2G38FI263I81D57')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    "'7B48A3659396G25DA818E6ID23GI3G1625481648E79CBH52C4I7A629ED86C7A68157C24IDG3I21E68')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    "'B67E93D184856A79C23IABH47E663518B74IH9A37D52642756I81C324HE19GF159G63B4HF78942135')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    "'E47C16B8993B58DGA616H9273546237E81I48D7CIA2F5EA96D28G343586B9GAF28A7I453G91D35B86')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    "'DGC8162E9B91753FD86854IB173A4BC8569G876DA9532C59267H41924GC15F818E96432G73F5B89AD')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    "'I12HC4F7553D17F9826G85I23D11DG5B8369BFIG1384E835469A2749A7532863B86I14E775628DI1C')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    "'9574CH1262AD6753I86831B9GDE649312GHEAEC9874628725FD391E9DB6387AG36841E29B18I5G436')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    "'1DB3E9678569782C4A38G6AD529ECG2964818B6413I7EI41HG5263863I2D7151946E7BCHGEB138496')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    "'ABDH7I563539F4A287687352ID1CH79456121248GF3I5E9FA23H74258D3F791GAC9524684697182CE')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    "'2D85C6197G352I1FH4F19D87235F52G13I8491842657C3G49E81B64BE37186I167HDI35289CE6274A')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    "'5F72491C8A42G3H659H93E61B7479AC5B4868B64I157343578F12II25H13FG4C1G264I856489E73A2')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    "'9274AE8C6EF138249743867I5BAC8B574A6975613I2DH194HFB753251F4CG988739A5FB4ID6287315')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    "'47163IBE8F39EHBG412H5D7A936512HFD7I33IF127458847359A6B946185CBGHAE2739647236ID518')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    "'3248E17F96159GD28CGHI236514216435I7HE39G681428D7AI23F5FD319G5828E7CB64I1921458F7C')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    "'97285ACFDC1H67492546523I87A2367H5AD9891BD6EC7GE4913628528D93F1GA6I7E2483C47A8F592')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    "'H5219DG636DC7EH29A97123F84E37E92A48F814367I256B9DEH7136CI517248172DHF539584392A6G')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 30,".
    "'145237HF9BI864157336GIHE2415869BA4GC4C285GIAFA7IF34852FAH79B3E4725CFD189493518GB6')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    "'4326A87I596H5BG413EA7D39862A4F253H79832679AED7951HD62CC24E679817863I1BD59EA24H376')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    "'46I32758A87A5DF9232C58A94FGFC5H12G94G9DC65B18182I7D653973158BDF6824CI157E4A726398')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    "'839FD75B1G16352H492DE18IG3F78E39F2A41F4EB79H3C9BH14F57I53162DG867843E29A4B19G8563')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    "'325F14IG876A829543894G53FA25694CB1H7B38A754964719H62CE84C79F25A9E231D6H716752H3DI')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    "'97A52843F8E36D92GAF4B731E8IB14CH576938F19752D9574268A3HI7143652412I65G3H365BG8A94')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    "'D1583G29FGC92F5418862D91C75A29648GE36HD35792A53G12I64H3715F49HB896A7BE432ED983716')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    "'C95A46H722F43HGIA518G59B43F58I63421G7421EH63IC61279H549B84E17F3D73896E216A5GB39D8')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 23,".
    "'I4568A72376193B58DCH2745FI11745C2HF9FE3849217829A6G53DC1G296458428375AI6956DAH273')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    "'85132DF9G4IF15723827C69H154B49E8F1735AC742689786931D2E7A5468IC2CB49G5H618F93A25D7')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    "'23AEGI648965834AB7HGD261539IEC71482F6415HB37978239FADED6G3951822534AH7IFI18FB7453')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    "'6E3879DA217I42E8362D86C19G51DG36H295F58792CAD39BE14786I21E86G345H39D72F146G123H5I')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 23,".
    "'1492368EG2358A76I4H7F59D321G135246IH48I17F35B2F59CH417C75D81IF2968G23E41A42659783')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    "'F94GA23E82A35D897675H93641B961H2E437C5G49186BB843F7E9A24I183E7FF8EG29A341G36D5829')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    "'H36D59G12BD71C8E69915FB74832FC17594H895DB3671G41896EC23275846IA9HF71235415D36I27H')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    "'E4GH2I613C92A65D78861G43B59471IF82356235479HA9HE31247F394786AE275F2AI83D1BH5C4697')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    "'13IG6E28448F19B5CGBG58431FI6138574IBG49BF3H51E2H491637E26CD1978378925FA4I1D78F352')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    "'826ED39G17E92618C4DA379H562BC7694158F85A23D9G149HGEB3FD6I31578B57894231F321FHG954')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    "'27I3FD85A4H62A57I351C79864BE86193D2GI21F74E38D37285I616A57C294834B86915G8G91E4CBF')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    "'165G3D82I8729654CAIDC812756381692D5GBEF1473894973HE6B1B4F5789A3E93F1D72HA78239E64')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    "'8975BF41CB13G94H56FD5H31I72I5A348F7248762E93A26C71958DBC91647H51F8EG93D24E73B81I6')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    "'6571293HD1438EF7B99BH4C75164IC5FH271F15972D3887234A69EG3EI4281628D56A3IGAF9G83254')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    "'3G15DH96289EC26714B64971E3H6IC41582G251I7H64348G32FA9EA36B847594895C71FB7E2FA98D3')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    "'B57HD619C3D19B78656I85314G2739EA46H215267H43I8DF92371592E4GAC68G16E83B94C8426IA57')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    "'5H69AD237B39768E14174235I8F4BH7F319E1968523DG357DAI862859671C4BDGA9B3685F23ED8791')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    "'81D23675I5394GH2162FG1I58DCCB856794176DAI23859513847BF4G56H31928BC941F5G619E72D38')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 30,".
    "'982GFA345F4C9582711EG342HI6196837EB4DHG51B369523IFD7184G36AH25I1B57I4HC6F8IB35D71')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    "'283G51469594CF8AB717FI2453H87EA3B94F41I67E832263489GA55A8CI46B72D6G8AI53CI76528D1')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    "'AC76842I55I81723FD4269CE81791635HD7BB53F47H19GD81926E3HF3721E4992A4HE73657436I28A')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    "'617982DE32HC541769IE46GC821A98576CB43GD19BF585624CH71I26I835G4AD35I1G826A87B46395')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 29,".
    "'32A4GEF8989713F54BD6E2H9137EAD2C8I679236G54H187FIDA523153HDF792268719CE4GID3E2618')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    "'7I24H36EA8D51F97B3AFCE72948168C45B79C57F9B4H12I47H13565AD92F83727653H91D83I4AG62E')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    "'25I867A4C317D5B8968F41392E7IC57146BH68AB3E97DD72986C1537FE9AD821B97485F354H62C79A')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    "'5IA783426374BEF189628941CGEI17H32F4586C74591BDE2A6I8373582GD1694B16I8EC77IF513284')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    "'3G96258D1681CI42G55D27H13IFI1B763458453HA2G69F78954A23E37A8FB9412H94753FD6I23E81G')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    "'189765C4B3724IA856EFD3821979A64238EG52DG18F397CH95F241F912GH534B8C945167475613HBI')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    "'752863AD94F1EI72389C84126G54GH6359BA92617D85C1E382I74FCA6B94E877H2FA5349594C87BF1')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    "'FD913578B2854GI6CA31726H45I36H9275ADI5716DH231B48C5796896451BG37A2CIH546E43F72981')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    "'E3HD62G19961C578242G4819CFE18C6249575967H3DA2D27E9A6833962G5HDA14863I27EGEB148936')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 29,".
    "'IEB14368GG34H56A298F17IB354375819DB69FB47E38114HF2C9752317FH59D5IG2D361H486E19BCG')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    "'938FBG541AD6895732257143HI6472385A6IFHC971524519FBD378BE37I681D469218C5G7HA43E962')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    "'36I8EA27D451B7CI8FHB79461537B81954C6534F2G1986IA43827E982F13E473A57DB8F9G6D5H9312')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    "'DAB73865978645I12C395A26G84IB4E67C8AE37H12I6461H4CI57BB4E89C17F3916G52D88F72D19E3')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    "'419GHC652EF8129374372654A9HE28I7AC646IC2DE8177D18639B5HDE136297936G5B481217489ECF')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    "'G4I82563A8C67419B5152FC98749A7EF43H2D6H392A57523GH1I46153B7649828I5AD67CD6G3982AE')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    "'AIH267534627DEC918453891B6G973H42F1EA6BC7EHI45D86A9372486CBI7517395412HFA2E786I34')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    "'657A4HC92B81793D65D9CE621784G5269831AC68475BIH29CEA746I8C51672D6543GB91H2A79H4635')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    "'451F8392768729E13DCIB74168574236EAIHI61G2H4538EC4192678CI2165G45763D9HA2AB4E78I36')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 23,".
    "'3G96A82454629751CH5A83BD79679B85F43A85432AGIF16C479285E24183I6GF87B49513I31F57H42')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    "'572I6DC816842139EGICA57H264693GB8145742591HCFHAE3D67924A98EF237CB5D79168687123DEI')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    "'C8F24I751574831FIB291E764385A2DI86379632E714HHDG6A3952ABC975864489326GAE7651HD32I')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    "'5C1276DI86I24H35A7GD89E126392368EG1D874A3I26EFA54723898593DBAF7C46G5192812GH9F534')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    "'615C8G429GBD956381893412F7E9F17482EC5C8AIB6477B43569H1A9687D53BD7E21C86923856IA4G')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    "'2485A3IG61C62G94H57E984F1B3H24GC9F51F9G51H32D315D62I8719BC6E487863741I5257D29HF3A')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    "'E94876BC16CH2DA97527A95C48698G61ED23A23H94G565F47321I8159GF83D23HB4195F7F47C2EH19')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    "'2C76H59A4F81492E3754I37A8BF37I52F84A1658GD3B94H21936E7D98152G632A67DC958G35968B14')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    "'317586D2I498BCA567B5F794C816C29E81G4175F4B3HI9D81G3562BFC745891954813GB6817F2I43E')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    "'2E4FI731819G38546B3H62417I54261GC58IEA8B4967397C65HA2D93A86574B7E4921HC6862DCG519')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    "'EIB6871D3H14B5CF97367IA4H52456BGI31H1894367BEG2C581649H3A76E9249623DA57H47E2981CF')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    "'97C6HB54A258413FIG6A47I5823HC5G6921492483A7FE16G54B9381583BF4I7CDF5791H2B79D81C56')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    "'2E71364H94F958BG313AH4976E2C15872I6DFG49E3128H2I14657C598G2C64A2468A5CI7G319F4285')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    "'9723ED6811FC9G842548E1B6I3GG63AB5H49H42396E17EA9HGD36223H4IG51675D63128969A258GDC')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    "'7514I83F26H45CB79193B61G58D51G68C249IBC145876846B79AE3AG6I34H25D5I218CFG3287F54I1')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    "'I46C28A751537698DBH27AE4C966324I1EH74G13H592F58I76B43126D85971CE37F14B989A82736D5')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    "'16E7CB48932G94H5AF4HI5163B78513269DG6IC4G1285274H9EA63E18273F94764H59A32932FDAG5H')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    "'6IH41G25C3G12596D824EFHC197I34A257H671F83459B852G693A45F98D23G1127I63DH54CH5719B6')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    "'FB7984CA5I5AB37D6834816E27I17H26354I52C79481FF94HE1G23GC28E14961D5FGI3829864C2EA7')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    "'BF98GE4137D19F32H558C24A69G7I6532ADH41B89G536H35D16I7238792AF5D624C58A791EI7643B8')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    "'GIC482561612ECI47885D16739BA25937FDH8IG264153643EHA279H74259C1F32FGHA945IA54C6G28')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    "'976834BEA528AIG3461DC5628791427653HI9GE83146B3H6BID715E98D27F1CB14F83759F37IEA428')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    "'472CFI815EFH174329931285D6G946EHG1238AC94265G57B316HDI2EH634G91736BIA4851I47E86BC')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    "'9237F41EHGADE836925862IA743F1I845237347AB6859H52C79FA4C8B59147647126HI3E9654CG12H')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    "'24861GEC9FG58I3241I13E24H67H93762A5DE17CH49266D21E93G8975486CBA13BG5I46848F23A795')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    "'D67I53H129EAF2847338241GE6I1G96C82D53FE2148I7H2479513F59478F32AA8B539G466G3BD19E8')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    "'9B6CA845748527IFACG31F54B89561G32H4I937HF41528DB915376F9E2731843485IAG261274685IC')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 30,".
    "'42H61CG5II7CE24H6161E9GH34BIGB1F43854C82957A6156HC7D298475962CA1E9CDB68GBF3781594')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    "'12E784I3FD89C62G51F3G951B84B6GD9351851482F97C8I31G54F23D2HE96716I51D7B3871H32654I')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    "'163I48EG29ED2671H3278CEA4I6HE46C921773A528DIFIF27A483532A496785H75312FDI649E8G123')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 31,".
    "'67C1B5IDH248GF93A5IEA3DH276DIB816E376715BC894583794FA2BFA78I354D57A32I8F83946E12G')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 23,".
    "'375A4H692129E63H4G8DF792513783EB9416IAE6743826241389GE26795AH3D4I82C6751C51DH7B69')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    "'C94F17E8B851BDI367BFG8354191BI746835F73528I1DE48C9A72F2639E14GH7954HB1C6A8D673952')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 29,".
    "'CBI458617175936DHB8D6AG2359986BG3E417A465IHBC2CE48A69G735194HFB241E68C97IFH723514')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    "'I17528D634C8IGF21E5624A37H92E13968G4347H5A692F98274C5114B73E68I5F9AHDG2383G92F14E')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    "'463I81B5G97H42E61CE21G3F894726HCD519389561G42DA59723F86751D839BAI42C78E62HC65I147')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    "'2A47E638939F148B5G57823I16D46589C12G723FA5D8IHI1G42653F72I41E388CD5F29G19153H7DBF')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    "'DHA625937756349A8B92CG1HD65A537DBH96IGD86C21528F591C4G274CF9518631528DIGHEI174632')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    "'GFB8C4519359G2AH46814IE67231I8DE327F5C46721I8BF7198DC5685CDA92791G28E46C34B67958A')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    "'45H27A39F9C6845G1B7A2CIF84EI65G14H32DB3589167178F2C9541B76895D335HB7D69A46I53128G')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    "'A6924CE8GE8B79F4137341H52I63IA8E6724647C29A5H85B41G96C975DAB63H2F18359G4C48679E2A')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    "'6A95G82D352831DF7I4CG26I815A9B76E38D4678C19E25H3924AG6426I57HC1A93B86G45758CD16I2')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    "'B37985A64514GFC8929H62143EG82F75C4AIDG9A26358E318D9F723I86715D224A93E6877FE4BH193')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    "'32H9FD15794E12G83F7A6H354I2E31G9684267IDH2351248351FG96GC4A52H9598B637A412D98GEFC')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    "'IA76523D835241H96GDF8379A5257I12D83FH23FG9A4E6A458C92G485G61B937I12C45862CF8I5741')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    "'236ADI785EGD62831I891537FB4851674I2CB37H9E146D6I31BG58DA7E623989534817FB286IGC145')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    "'6H1432I75E92FHG431G4C591B8659482GAFCC7H15F24916B43I87E7183DF2E9IB3715864FE492H3A7')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    "'879FED2134563218GICAB8975645C71824I6A42693GHE689GDE231C2H761I459AG5342FH4E6IB8173')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    "'9EC8B416G24FA7E93H187F3IB5469A4CH5725BD7618I337H92E46A386G45B19D59612C877A2893ED6')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    "'F53HA9427241567I8C9GH2D3165B41CI8GF569HA75D3253742F8AI1H693B57D7ED8163B9C92G54F81')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    "'76135IH4B8EI7D2C61423H16G95FI4AH3275B3EI746181785629CD918EC74265234961HG6DG28A3EI')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    "'678B3I154E1C674B8I9D21857C6E8B9D6317DF7831I5231925G46H4FA8IC7257981B53D6E23674HI1')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    "'271CHE694F5D179823398264AG59B67DC5184375H1IF2HEA926743D37A5I862216G48C9EE8I6CB417')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    "'2381D96E7GFA35H492594BG68A3I73H61524216E43HG9D85IB736149E78B31F627ACD9851CH659742')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    "'65D27H13997341FEBH2A83I54F78I17B6543B35HD1769G46539A82D15987CFB6H23E419G97C62185D')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    "'9325461GH487C1I562AFE28749376D32I81EH5C174B969216EH37DD51B87F93928F317DEGC65498A2')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 30,".
    "'4IF51827CB5839G16D7C1BD65HI6B1HC97458D3572IAFI7E1643283E4IH7162FBA435789897F12DEC')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    "'E491C7862A32F89GD57F85B439195C214G862G83E64I1A46H7I23E37569H4B191D52C867F82417IE3')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    "'CAF57I4824281369EGI75D823619B57681C4714EI3FH28CF21459GB47F9A853369845BGA1E872C649')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
     "'A9EF328748G419E62C23FD8G9513B1956DH7D58G32I16679HA45B3568GD921C3D72H15F9AIBC65748')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    "'9D23AF587CH7D59B166152784CI4G98BE63A63H97A52DAEB364H97193G54BF87428F31I5EH69217D3')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    "'271IED3685D36819GBI8F273E4153BH46A97D1739EH2F6I81B7354FAI4837B5754269A3H832G1E469')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    "'IE3627148624HA39G5781ED93B62794A63HED31G58B69HFE932D1759B73D86A38F19B547AG465H29C')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    "'A94725C6865CD1827I87BI36D156GI4532815B49H136G1832F7ED953F81BI47H42G96AC579A35462H')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    "'CHB715964941F3B85G57F894A2C8IG14CB562F45I87133E12679DH579631DBHA8F429375432GHE619')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 29,".
    "'86417E93B9CB64815757192CFHD657BH94A3HICE14726D12G3685I5D1326G9HC8IDG526A2671IH34E')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    "'421E8C697537619H2D8FI7BD5133G28491F598E36A742146B57CI8718B56I3D2I6DG31E84CE981672')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    "'H21G95463E4I36H71237F421I8E18DEC9276F3G2849512596178DCF1B95G34HHG34B61I5594A38G62')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    "'E41I32F8738976D15BFBG8154393967A58B424HF93E7A7E12H43I616I27H45C8C74159BFED2I63178')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    "'83AG6I2544578219CF96B35D8AG698375A4BC7DB1968EE21FD8793IH35164B71F2748EI3475BC9186')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    "'8167DC2E94328E91F7IG56213H4964E8A37B52C74FI8A71H29C456DI71286C5615C94BG8832EFG149')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    "'754C96A826BH51734I13IH4257F6GH93142ED32G5FI81915B84C675FG8192D31932G4HF54B86EC7I1')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    "'CB4EH96179H73615D25A67243IHHEA976432734B15F98962D8C17E748A6C295A5F42I87CB39857FD1')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    "'413EHG9626BG139854985D26C7A8296751CD3F54AH792ADG29C56H25AG9F348IH654CB717348126E9')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    "'48GA3EI269612D7HCEB5C896417712FI4853496358AGBCHE721964E79CFA248FH47295131325486GI')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    "'87392A456961485GBC2ED37F8911425C8FI7HE9AG6234G63D2I185CHI7142F5617EIB3485426389A7')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    "'A56H27D3ICG9546A822841CI7655913F8274627914HCEHDC57B6I171C985FDB2984FA753DE6327918')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    "'B8G936D15651GH42C939DB51H7F5BC7I41FH1IF52847C7D86A39B565I87134BHA7342I65432EF9187')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    "'243I51HF7716BC8495EIH476A23485CIB716AF785432993B761HD557D12963H68BE43I7A319FHG254')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    "'7398E41B6D52I61G3HA863G2D9551H29G46C273FAD8I59F48537B1F81C42I753BI58G14654G61I2CH')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    "'1IC24576H6428GA359G5869321D5893A26G4B64E8GI131C74698B5I56D31H27DBH796A35371E82I4F')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 29,".
    "'219DHG35FF7E213489D38659ABGID8632571157HI4C62362GAE9HDG63AIE8245487B69CABI1843576')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    "'1759F43H2B86G53914ICD2A8756618BI3E4G5CI46G821D27A853697368BI45A1IH3D567254B6G189C')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    "'D2H563971I57124H3F613I8G45B1C4H967EB2G5DA36988I67251C4287349FAECDI561782561B7H349')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    "'978254AFC156HIC247BD3176859CIB5817465A8FG4329764932EHA62EHCI4A748176B9CE3IG415628')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    "'HG21469E3EF9238G14413E7I68B485FC1BI76219E78DCICG82415632H51976D19F47B3H5745CF8291')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    "'C67B45I18D9AH67B352E8931F7D4EB1H37961G89E6342369427HA56215348GI58D72961CGI3AH6542')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    "'6G4HB93513584A67I21I23E76HD73H21F495E6IH7423142A935GF8I67A82E4312E6DC98G84357IB16')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    "'53H27A49FG6B49381E419F58B3GFBE9871D3378F4A5299D15237H6864G59C1223G1H4IE6A9E36B874')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    "'FA4E93B783576H2ID1B98D17F3592E36G48113F8245GI7H41593F2756AC2H49D1879526392C84F57A')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    "'965HA34BG72364I58AH1DE27639GEBA94638418CF59729F3782DEAB8F54I3711972C6HE43451G82I6')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    "'6I7841CB5DHEC9271623AE7FH49962GA45H38745639BAC1E92846747915HB3FFC82D71591526I37HD')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    "'984GBC6155AB9643783761852IDB37591HD6481FCG295FE98427CA4781FI352A29H53GDFE6C427918')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    "'F7B314H599346EH12785A729D6C56C92748A7AB48356I948E1F2377C51I62D8H41B75C96FIB3H4175')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 23,".
    "'5D72H1396H63579DBA92A4FC875435A68G2IIH7235146B16G94358I5C6748127183EB69D6421H95C7')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    "'5GDA8369B19B476E8C836IE2417I36GA8425241359HF7EGH624A933418E72F9625IC47A8GHI2F1345')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    "'B68A95G34D97C86512AC57BD9686A29578DC94E23H76187C41F25I32F58147I8G96B41E3ED1397F82')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    "'EI8712DF3327FID1HE6A4385927385126ID7G1F54983B249HG31E62398GD65ADE12F397876859AD3B')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    "'579AB4368D1C856792826793EDA7926H143E3D89B51671F5374I8BH57I46BA3234E71F89FAI23845G')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 29,".
    "'EG41269HC9CA58724F286D3I7A564723A85IA95DFHC72CBHE97164492GA8365HEC624719671953HDB')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    "'FC7H294512A57F48I34981E3GB6193E8D27647F92135HBH5367I149DBCA5768E87649A32F3A872E4I')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 29,".
    "'BE63A47H9I48FBG35A73A5982DFADE972863876513BI4329HF415743HEIG621AFE482739I72613DH5')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 30,".
    "'HGD19C52F3E9HB67D1F217548CIIEH362417614975BHC372DA8596281FCE749D3G198562I652D7AHC')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    "'B8E1639749362GD851147589FBC752HC64I1AI8547F2343F91BH7E649E1GC2H7AB389465358264GI1')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    "'6C72598A452H431GI69D1HFG3524HB37A59695G862ADC613D9E728I28163G45675BHD3191C457928F')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    "'389GAF2454762C5IA81BE984G63AE2864I7376C15982DH493GB6516CA49G528547382FI12I8EAF437')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    "'A4E68293G9273D5AF83861I75D2G9CE6H2145HB491F7CF14G23H594518793BF73IB1685426H43E971')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    "'F7C85A9421549GB386892364GAE7153HI4B6FDC521G982H947615C538267A9DDAIH35267627I415C8')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    "'BEI1H436784627C95A371I65D82F71H95432D85G32619293A4FGEH7A65439BH5B41I83F78C9F2G51D')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    "'F8C5179247E49B61H391234HE6GDF5A983G223954G6187H12C64E9741H3I2E6H95D62C71FBC175894')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 29,".
    "'AEGIB63846493GH51238B415F7IG42E9H613185B36DI7I3FG415BHHGA4652399548BC761263197HED')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    "'8B95A34F7F1C97458B4756H23A9G54281I36C26G49A5H891E3F24737E64B1984F18IG23592H153G6D')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    "'6H15I7432B5CH461G9947213FE8I7F15C2484329F85A75H1GB4396HFE719CB4791C2D6854CB86517I')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    "'B78I1D6355I3H261G4A64357H29742A9C85668A457I3B9CE28F4G13F95H74B1B1E349G687486A2EIC')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    "'361487EI2IGD253681852FA9C4762571H9DC4CG56912HI8A4B3765BG9154836845CI67A213627HE9D')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    "'6172E49CHD52H93A7638I16G452765H42A93914C6G28E8BC91574637F4BI5815D86C17B9B91E7HFC4')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    "'28C4IG156D91E68723G56213DIH8B49F53GA9CG18465B561C27I84F397D8E128752AICD614B63E879')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    "'736829DA5E28AC469741I6GE328IH7CF425124C85A76IA56B97H43193E7HF4BDG63129855H29F47C1')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    "'G31I64825I68E1B743254738F9A45619237H187DCE2969BC8764155D32AI6H767I8543BA1HB3F7E49')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    "'H29F31G54A6749E3283E47B89613A62D8EI7HG25C96D1D95F17H3298CD7B165254916GH3AGF58C249')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    "'5I14C72H6H43IB6G5A2G61E839DA42G5936868G4CB19553986A7DB92D81C67E3785F42A9FA5I27483')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    "'8C51D69727I6HE2143421397E8F59G31H62DBF8EG4319143I62H7EG69B51483D3598G62A2A86C4GE9')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    "'H42F13597379E4HB61A65792C8D18I37D2654579B68AC2CF51H9479E14B67C8G84135FIB6B38G9451')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    "'5BD3H916716374EI2HG98B16453I42F5A87368A374BE95C79H26D123541F7IHDAG8925C686937E12D')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 30,".
    "'F58491C2GG1B36H94ED93E27F8116D83BE7I8C95761B42G59AD8369A57DF2H3D87B9CF5136B15H74I')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    "'D8A23F759I56D78B31723A9EH6461B89G5D33H95A47F25D72C69H13B89G41FE14762589C65I31847B')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 29,".
    "'F39G41E82A75B683498B43IE1G646721C9EH8215IG6C4E39F487123I48GF1B575FI1B4HC28A45C96G')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    "'2164C75I8EGIA823D6438FE9A27175FH3942968421GECBDC97581686D75I32A23761DHIE59AC8B764')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    "'B1H45C97665D97823A37962A8DEAI46B78357B3EH9416568413GI2562CDI781HIG165342A342879EF')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    "'B16D35G98G9C681B4E54H2G93A686C1425GIA79C56824D25H9G631FE73819B49324FG5A818D95B76C')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    "'I36E27D1885B61D3GI1G48935F23FE79A84BG48B3EA96B19D86C576H42531G95279F1DH39CA74H625')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 29,".
    "'9EA76H23424G1936EH8635DB1791B7D95CH68C57F29A4F9DC18G258D25G96A3E76C21D899CA4H62E7')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    "'B56874CIA193F5B784G8D9135266D59371BH2CG8A65498I14E2367582D13G69CG1I654B8F4I27HA35')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    "'63AEGI24H82564AC7IDG93825167AE9634H2I32D58716864AB793E126CED8975932H71F4GD86I1B53')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 29,".
    "'G941328F5EC2HD67I118675I4CB246C1HIEGAE39742689782F53D152IFHCD7138G41IF25F14527H93')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    "'7168IE3B48C94265GABD53176H9E87A4326934B967AEHI61H52G346CB45897AG14BI3F85E9817F42C')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    "'3E64I78A2287351IFD149BH6753938174FBE426EC871I5GA69283456124IG8C8DC67519B9273AH465')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    "'9F2DC581748721F53IE13897B46E8A37I62492CH64AG56G41B59C8196B4375HGD86E139235278ID6A')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    "'5C46H71B9G82A5I4361F92DC7E824837FI5A69751D32HECA892674G624A3H959D18752FC385IB6417')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    "'461G2H539257391DHFC8I564712C9DA5F287F2E87I134871B43IEF9438A2FGE5687D39A21BG6I5438')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    "'436GA5H29BI73681D585A92D36794A68C57B67CE2A9H4EH2G496132I7158CF4HA6D397524C52G61I8')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 29,".
    "'H42I6A73E751H4C26IF9C572D816231E94GHD85C72A96IAG8D63B5586CIG2149B75A4638134268GEI')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 23,".
    "'H39417BF57A68E294345B63I18G946152GH3128C7I564EG3846B9132D5786IAF95BC14877A89F4325')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    "'985CBA6742A4657HCIFG38495124371IF852A96528G43BHE437IF1E49718BFC3HA96247E726C5D198')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    "'29D85G13F651CI47B8HGC162549FA94G852324391EH76758B3F91DCF194278558I13G4FB4276H53IA')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    "'86D71BE39G2IC65D811C5HI4627487IE612395314B8GFBAF378459CI5671B486A82945CG742EH3961')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    "'21HCGD5966435A9BGH7EI8B6431185749F23CB6A8E497I7DB6C185DEB867931831954GF2697CAB548')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    "'69E728D1CGDBA368E9138D5I2765F41H793297C26DE8A8BA5I3647C41BE6H796B73I84159H5714CF2')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    "'D6H37519B1E96284G3327AID586726IC158453D78691BIA8452GF36132498EGHI7C65241B4EH71639')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    "'193B87D6E47E6CA28IFH2E491736GD9A83529E83B71D623A4567IH8DA73I5B6G63512H949258F43AG')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    "'5493H7BFA61G42I583CBH61547913275H49F896C41GE2GEDB96183815624IG3BC49781F59F7EC1842')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    "'9E13F7248647582IC1BH39AD675A95D86G3247F329H1E8CB75A46987D52C61I1937FDB5HE26198C47')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    "'F89541C2GE34FBG189B7A38I465918756B3D3D62IA875GEB8439164F38G51I27529AC4681I862DECG')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    "'6A43HB795IC5A476822875F91DC871EB3D693BF4I1578954H76CA2938246AEG714HEI263FB573149H')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    "'1E9683D2G28G45139F3642I7HE1HI2564C71674IA38B513578B94FIC52187D6G62E49AC8418FG3E29')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    "'H1I52C46G523GD6HI1476H9A532352176I4HAFD958237987CBD615B857CA69441I68E37BGF32D91E8')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    "'2845FA9C7F1G983B5493E47B68A3B8D7I61557612H3DI149C56H27G93146H52862GCE4I15A42I87F3')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    "'2G18946CE35DF7B189F98E31B74967DA2358EC89674214123859FGAD3EH9726795BAF8438267431EI')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    "'15FG8I34243G26E98A9824CAE76BA5693H74C74A58F92698BDG3154679CH5B15137B68D9HBI1E4763')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    "'29F578A3D37546A28I4182CI576862C1I745ED3726198197H54CFB4B19E76H3FE7H349A2983FBA7D5')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    "'B71D86CE9683IE2147D95713B867F85B31I4CA48G926552964A37H93E84261G7BA59F43H8F41C79E2')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    "'4EH62973AF97314EB8132HG54F99FD5173828G29361D5351BH4697H96B75A4325A48CG6I74CI1F528')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    "'B71683ED9E694GA823CDH92561G91G46EH3BBC47I8156H56132G9D358126GI4947CHE6122FA479583')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    "'H94G56B3176C1824EIA2ED3987642C17H96E5769348BA9H1EF27D3CA95H26D7B48F9731565G31D2IH')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    "'3914GH6B552463IAH7FG8512439289E1D736753296HDAAF4387B9516B853IDGDGH9F231595C74A826')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 29,".
    "'ACF7B9458852641I3GG49EC8B1664BE739H1AH5294GFC97C86A45B3658IG2A4DBH516C791973246H5')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    "'315B9FG48FHD751932729348E6A864EG1932B9G863AD5ACE49B87F427659AH3516CGH429IHC214657')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 30,".
    "'8A37I56D27BE6D83IA6ID31B58GBH7461C59I34HE2167A65739B4853H17F92DDGF2895139214EC8GF')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    "'A75C826948D31965BG2I6D75A8351FI2G43878436EBAI9CB8415678F17592DCI7B431F583546BHG19')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    "'457AFC28IHI372456A216I58C477A8324F9E439F5H21G6B51G98C4E31I728469461H5CGB78B46359A')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    "'526H9GA34CI14F5728D78C21E963429G1FH597F58CB1D8A52F473926I7584ACHD7139F5215364B98G')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    "'428CAG9567C94561BH5AF9B8374169HG42358753926ADBDC6518I7791642EHCE63I8A247D82G35169')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    "'CFE9H714229145F3HG7842AC569594HAF723ACB749865678325DI14782C96EA613E78I24I5B14F83G')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    "'4E87239A6C6G9145289B1FE8D7339DB7E861HEF4317927128965CDA8B549F376792831DE345AFG28I')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 29,".
    "'7895B64C1EFAC479283428IA65G278IED613FA42837EI5C91762H4A9GH65CD28364GB195D25I13G6H')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    "'7A59C8642I38462G1EB46A75I8332D17I58F6G158D3298E93F27A4HI3267D51A468EC29752G49163H')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    "'3H517264I927DCF1E8641E98B737642AH95C31I76E2848259C4AFGE91837DB6643592H7AG8B41F359')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    "'4H59A3672297EF4381C16872D5I24I168CEGA5F72C84IG8394E26AH91G2FE346G24C59A85C41986B7')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    "'41F38E792G85BD9163293617EHD9675C81B4812IG4EC63DE1B68G9651H49BG342735A69HIC87624E1')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    "'431G8B9FEH2I165G43657394AHBH7D1EF3296913824E7235D798A62A8543697574I1FB3H96C7BH5D1')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    "'38476BE1IA26D95873E97C81F24D38957FB19E12FH34776B413H5I2968DC1GE7H451I6321C52G69D8')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    "'38FB5I41795147FC2H2GD38A659648A32G95B9C587164517I46H32IFC5218G4GA58D96324B87F31I5')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    "'12H9CF547436G85A9BIEG2413688126G94EC3F78E42194I51BC7H6B65G8439197A6235DHH34E1I672')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 29,".
    "'478AF9B35296GE3AH41CE24H7698ED917326361425HGI972FHC514FHB7D3591547IABF38391856DBG')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    "'93GH2D16E8549613BGAF2357498219356DGH7854IB136FDC87A529742FH35I1EA3249678986715BCD')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    "'2F14H39G5H43E79F12EI7B164H3897C54A2632F98AG5DA5DF7283951I63H74B2674I51C834H7BA965')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    "'EC9D78216B87165943461I32HG515D7HC9623IFE1247H7286D9AEC391845FBG72D6CI85158F21G394')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 29,".
    "'3416G5BH9927DHC615EF892173493HE1D762GE23FI84114628GCIE1I6853DB7274AIF538HEC47261I')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    "'5D3FBH19798B15764C6GA4398B5BHDG319567952F43A8163IE8GD231ID6E872EG6H29431284317EIF')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    "'45328G69A6H15DIC2727936A5DHH65C7D12941B958G3FICG1264H55C8ID27A6174865B9CFI2G13854')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 29,".
    "'14785639BI82AC4657F3E927HAD2C96AHDG58DEG9321617645B38I921E84G6C5FH37I4217D32F1EI8')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    "'E2GDA368993A82F45G4H67593B18F41IB3751I37456H2E72F38A9474H95F231C19B74E6826E81C9DG')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    "'4E2I6G1837195H36DBCFH4127597D85AF2C9I51B34H7662C89GA4E674H9AC2539E42G168B81536I74')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    "'5DH32F7916A2978CDE739E14H26852463IA7G94H215631FC95G24817I685BC44EF2371893H2DI1675')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    "'192564C78FEH739421437B1H65I483F5GI2AEA7294H63926C815742D98A67C5175C4B986HF3G95AD2')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    "'3B6951HGD7EH4639124198BG536E62GA3498HCA54927FG9468B1ECFCI1472851843BE697275968CDA')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    "'94H36G12EG61E29C8425C184F7ID71859BC66E34A2897HI2C67D157925A36H41DF27H9355389D67B1')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    "'64AC895272E8647I1C73925A6HD7384EF1I2A9FG32D85D25I18CG62749138FE8615BD379EIC867142')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    "'A6G85C42I2481693EG9CEDB7A689A43852G6826471EIC753B9F84A732EIH641F1D732985589614CGB')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    "'37F5A92H49E42HG136821D63IG5637I51D28D91G2856C25H34F1971428957FC3GE612849689GCD51B')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    "'B5G814C6I3A67I5DB84H92F35A757A43B698239F81E7D64H9GE1327DC926AH515B843967896G51C24')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    "'G49C16B8562A458I3G583IB76148F45C21I7BI3714EH6G51H96C4242365A97H875CD91621FI27843E')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    "'I25386A7DDH72513F91364GI8524F37E821I87219CED65IA62438G597HCA642618924G3EBDC765918')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    "'8342I7EAF75B13F48I16I8ED237672C8A94E5916G48B3DH3592716G53168429268ID7C15941C25FGH')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    "'61352D78I7I56H1234BH43795A6A78492CE694CAEF872FB583G491B41967HC5CF7E2841995H1DCG62')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    "'G641B9H531538D76I2982CF51D72D79A85C6C6E724981819F53GB468E49A37243I2GFE1H27A53H496')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    "'1896D7CB552FH9C14GDCG125986D18763E92672I5H314EIC2A46G893427F85A285DC17F9G6A85I342')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    "'D8C157B696172I8CE45B9FC4817EG291683448A57392F9634HBA7E3257IH64AH69142GC5GD135F298')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    "'8392D1FEG152FC7I846DG8I5213394E62AG85BH4713967619CH4E27159BFD832DI813G65C86574A2I')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    "'G94E36A28E31HB4F79F8B19753485741C26IBI375614846192HC7E6D1IH23G598G31E4622E37DF8A9')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    "'B354167894A9758FC2H67IB3415FG15D8923C24971HF55986CB7D119DH6B35G58314G2I627F35918D')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    "'G91F32D8553281DG9F4FH97521C5GC84F21IB61C59D8784IA27E363B89E41671GE6B39486947HA3E2')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    "'82394G56A694A5HB73G1E3F2984278FC9154536741HBI1DI2586377A6CH5D924829173FEEICD26871')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    "'DCG1569281294783EF685CIB174362G91EH489DBF5G31EA74389268AI24C6755426179H376CHEI241')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    "'7AEB4I63838B76E19D49F13H25G9F43EG1828274195C6EA3F82974593HG6D21F4H251I737B13D9865')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    "'58D2316GI76I54H31B23A97F548C98G5FA421E72I48C66B4183GIE4BE817963981F23D75367D59HA2')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    "'5F39G12H4728453IFAD19H26375A47C58F29239FG41H56E81I27CD81B49673E5DGC1B89696C58G24A')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    "'B9F534A783H7IA6425E14H72C966D27138E9H73EIBF4115I64H23G98E461C2G23D75H1697F19B3485')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    "'92H734EA64A3EIF2H7G65A28493H61CDE279C7D82965A95267A3HD1IB4536877459FH13283F2175DI')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    "'2E3AG4896IA4C68B7587692E31D64BG8AI357395268D15H14C92F7EF9C1742818C45B6IGG42F98A53')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    "'3I4875B6A12EFCI478F78B41395G19F83E4B25C7D18I64H69E27131269E74C8984C12EFG53G86D12I')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    "'86413G25I2E78F94A3AC94B56G8C189D6E7297F5321HD542HA79637I36H14B5648G25C9A25139D78F')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    "'GB3H56419641G3I52889E142F7C6973HA542B1C49587FE84267I31B3EIG81649F71E43H24A83B6759')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    "'4C58G9216H1I52647CG62D3A895E2C64A9876D72983E11895GC24F394AFH752185732I6DFBG954318')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    "'D91HCF52GC87B54F9162E9174HC6GC954182125836GDI894A7B356715BDH36946H9735A2BCI561G48')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    "'783I62DE1DA23857I6F59AG4C28519FCG2486GH12D95C2439857AF1BF89537D5492CG861837461EIB')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    "'39158F27D6H72D91CEB4E3G1869A69742H5357C8619BD482IEC6179B86C54AGG564A239813479H52F')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    "'8G1C4B569C59716DH2B6D9857ACD56I8C2178GA624593392571HDF6947BH135238165IDGAE7439628')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    "'G159DB3863I28E67D1H46137E2I65A8CG4B9D3GA2956H9H24F53G1EF8294A73974F1C28521C75869D')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    "'I16347H252DG8593FA8E36AB9475CB79A68449862C17E17FD8523I2FC4591G8E14786I32798CBA564')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    "'23H5DI176G9E316D8B146827ECI653GBD98A8741596BCBIA683475HF73154922319D8EFG954G6B318')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    "'AD6978352H39F25741275134HIF689DB751C2A35869G4EDGI13628G6A83529445B19G36H389DFB75A')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    "'973BFE1D8F2H3147595D1798BC63845217IF5G69DC1H2A29H6G3544C2617H5986ABIED37I7E48C612')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    "'8G6DB53194523917FH31I86G425ECA68429GB89A7CE466749E21H375H143I6291D62EHCGB36GI8E41')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 30,".
    "'47951CH2F68142G53IC2E698A477816329EDCD2I75A68I56HAD73B2IG1FE3D88EC7942A64F12HC579')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 23,".
    "'6G18B39543D95G6182825D19FC7A4I36728EF35B18GI478B59D163792E3F41846A82795CCE89412G6')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    "'56H9G143B79BC4E81FD13286GI56H72D9CA5231E6798D54I13H627A23HE67946G9DB3158854971CF2')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    "'4F9EA38273128745IF7HE6I214317BC5D6IH639B81D578E497623AB86I4173594E7FC12HC17528DF9')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    "'H27FD5I3143I781B6EA6E32I74H75I31826D6139DBEG82H46E793A5H21GC496196H24CE7DG3596812')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    "'F49C821571E36DG98B278591DF38G15I42F3DI6C28571352716IH443H91E72671926DHC56BE83G149')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 23,".
    "'9G1325684428I76AC55368DA72I168B5I4CG39D78156BB75C64I18716EDB8932598136DG4HC697152')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    "'5CA7862D979D35B68A62HI41375315628I7D8G64C9125B9D51G836A97D63H5BE63B1H9474H27E91F3')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    "'8FG5319B432EI6DH71D91H72F35658149C7B71BE3H6499DCBF7518DA67H52932874IC1EF35I12F784')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    "'47C59H61292136D8GE8F51G2I43847B61I35AI253G4H6536D89B171BD3597H6753FA8B4I69H72DC5A')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    "'G1B86945335F241I7H948EGC621178I25CDF6B3G845194E9CA6782FHG591234432867AIE195B3D867')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    "'GEF981432842563IAGC197BD658869AB7CD527D35H1IF13E946B8G273594FAH685GCA429DI1862573')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    "'67958A3DB15B93D87F84C62G5AIH2516CGI47A94H52633F49721E8IAH256437527C48F91436G91B85')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    "'B7FCI851484C12EG695194763BH4FA7398EB5924A83G678C6EB19D9DE683127F81B57I34237I4AH65')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 30,".
    "'6H79D31E25BD7AH93619362E48GB64G39EA8895FD1B73C71852I468I537A42F3F7DHB1E9BA45697CH')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    "'1B37F4IHE469B5H371E8G931D62842FAG5396CG98514215I243H7F2EH39647A7I3E1D8266A4728CI5')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    "'D39B85A6716249G5HCEH71369425169GH342724F31IE889C42E67A6237E48I18D53A92G6GA9B68354')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " 'CH4571IF22I73685AD1659DB3874CH1E962G72A84695C659GB381D243HI67A5189D75FC2EG6231498')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '1968D35GB35279F18DH74B15963C6I721458248E3IF711EG48FC9B235F14IHG8AGIB54636D97C8521')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '6391D8GB547A532H962E89G61435842GF3I1BF91D37E8C17589D6B462917H5C385FBD91G79A83E624')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '7351D6B9828F59G1DC9A42H3765FH4329E177C5618DB9129E4G83647A9EC86B352H61I74FI847235A')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '5316B9GD829G4A85C6H64E37I21C1E27498FI74HFE321286319DG5857192D6CFDB7531891I3F4H752')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '56384B71I9D17E36H2HG29613D54G13B89EFC95416B7862H75I41CF95A3728482D56I13G137B84EI6')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 29,".
    " '591382FDGC6H47A592B47IFE831469ABC875H1E6479B3723598FADI5FG3421H184256GC9C72AHI456')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '4E82IC671A79E462383F218GED9A4G58I3266857BC91D92C416H7EH3BG649154573918FB69A2EH734')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " 'F7392HE4AD5B137968189EFD27386E492ACGCB15G6894I47HC1652G5I314B8661C28EG4I42879F31E')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '4H2615CG9FC1897ED275IBDC861H5DA672931269E34G8397482F1E93852F74176531DB8IAB49G8536')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 29,".
    " 'B79A36E48A35748F2I8F49B53G13F28I47E1HG42EA963E19637DH2F8G92C415D925163HG15C7DH29F')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " '47215F98CE1HI3762DC964HBE17B37549H618912GF345FDE1387BI3A56ID728789A524FC2FD8739E1')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '428AFC7951E67924H3CIG54812685G6DB9CA31D57I6282FI83A75D386E1D279B4A937H65975682DA3')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '978561DCBAE3824967462IG3158FEDA8G32921I34F57HC8729E61D213845GIFGI56314H28D6GB9531')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '1HIE62473736DA82I552D39GF8A9C72456AH64B18957C815G3F94282DC5FG91IE78213641634G9BE8')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '52D13I76H1HC4F7952G6IH25CD1C41857B96E2I634G18678IA25349G56124H3341H7EBI628F49C15G')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " '34B5978FAEF7AB89349H1DC6527D2E7861398GI4AC2561F3B59G4HIG42E8613385FIA742612374H9E')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '97564C2AH4685A27C9B31G985461B78365I438D95A27F9F54G28A3CE9G82D61F27143H9E18D65I327')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '2814EF93GDG6398EB195372A48F5A27I83F4I6C1428EGH74CF5219H75623A49634GAI2851I25D86C7')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '8D351F2I729734H15F6517B93H418B3FD975G39E81D62E46972A3HD29G5HF3A6G39A48B581E26C49G')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '98175C62D4EB19678367328DI5AEA286934783GB1D56I49F7C51B8236AI54G8945678CB1HAG342569')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '8715C62D9EBD1978F36932H41E7382G65I14IE648173247132I5FH45CF2GA9H27HC19645I16845G3B')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '4F21879C53175IB46H8I5D367B165H7DA32I9C42H6A75B17C59F48E16B74893823F59G4A97DA8C562')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 29,".
    " '8E39FB1D7ID67C12852175H4CIF6392G5D18174H6I5B3HBE1437693BA78F594697D52C1H458ICAF72')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " '798D25A3FBA4863579C56G19D286EDHG3912G91642CH583B19E67438IE6G24A45G12H9CF2F19D35H7')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '76E98C24A13D67285II82E41CG63G41965B8B9HE43G6A16572H43IF37852D199B54A73H68A46IC257')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 30,".
    " '128CF9EG497E18D2CF436G5B19H7I5B4A68C3286EG4A9F1D38952741F937H5BH93562G412G58DA9FC')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " 'C48126GE97AIC5H426B6574981353197D68B8926C15G4D7F58B39A4152I7HF3B6G183I459C86E4127')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '1BH54G69C73D98F25A69532A48G851I32764CF78451B99D27A6EC8DH5219376692EGC418173864BE9')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '53697BD1HGHI1345621246E87I3841CB97F52E76D189393F87524A253F87A9DI1HD2537FD67C19E82')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '726945CAH1E3BFH497D8I731652F82193DEG745HB6931IAC574268574261HCIC19E8D6728BF397145')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '93H52176D541F8GB936BG4398A5C75846A9BH2F13I475I41752C864H9213FE77EB964CA816C5GH294')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '4AI76528CF32148EG9758IBC614F38IDGE2195D213867172E86C4IAED896372386GB5491297431HFE')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " 'G45I23F81296D1H5C78CA7652D925H3741FI36IHEA74241G69258C5C28A7D9698D6B31G5A76IE4328')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '92EDH3167FH75I1BC4C4A726H59542GAI638H7F3451291932685GD3742IF85195H713D6B6AB48593G')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 30,".
    " '68E12ID7C43B8G619EG19DE3F822F4958C1G9EC72A6H487A3FD925E4FH327I1C17569B482I81D75C6')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " 'F5C41829729HG3E6D141769B3HE174562CHI8F34A95272597CH1D67D18369B5I86AE2374EB3I74861')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " 'GE3FA28942AH94G65394658371B13I26754H762E84C91H54A392679BFDG5381HC51B6DG94G13I86BE')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '96715HC4BH1ED3279623D76I1588GA4935B66B95G13D8C45FH2917785B3IF149FC1842574215G6HI3')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " '75B1469838439G2FEA691CE8247FC7518D29D19326EHG582IGD13F291375HF4GCDB6819586EDAI723')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " 'IH1527643527CFD819463981BGE31586B79D94F7EA28CG2H34915F239178DE6FG84C51925A4FI2837')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '217689E3DC4F5A279885I74C162728DIA365FEI823471314675B9895BH73146187I642CED3FEB198G')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 31,".
    " '281D75CF9GIF82C415435I6A87BI5281GFCDA6G93D5823D8EBF1975931BF7D8BGA3486596847E92AC')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " 'D62I5378171524HF9C3I81F745227H31F594AE6I2D387943H75B16HD7639ABE5314G286962I58A73D')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '325AI748617H43692EFD9285A372G98615DC8D37E26A95F13I47B895H61DG32CF1B9G58447BH5C916')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '2964G1CH5G48E39621E3AB867941376B89EDIFB1548738453G96A286I74B51321739E4HF45C16H92G')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '1HI6DC57257B1HI46C3642758A986A9E72CDB97F348155DC18B697G28D153963419267EHIE6G38421')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '632DH9715E18762IC4IDGA53628273968EDA491BEG683HF5314279357824AIF1293GF845DH6E91732')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '9G2431685D86I57A2C1E36BH79415G26DC9H2CD8I16G586I37E241719H2CE463DB569718586D17IC2')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '7CI564821456B18G3912839GF4E9HE67C14212C84E69747FBA9H53B58317D963G49F25HA961EH47C2')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '6498A52C73GE642981BAH37I6ED59F1823G4D13769B5H8274CE196D61G23I5HEC78ID126I82561G43')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '3958GB6D1817D96CE2BF4153978I53B67A8417H54C26IFDBH197C5E1H43I7267B46H193539652GD8A')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " 'D1F938G52293G5F4A88G5D21CI63BI86E17DE61I7D38B784213F595416H32IG8C71B964596B54G13H')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " 'F95CH14272DH95G631137426E8IIG8154263526379HADC14H6B97573B5AF84IAI5482G636487I3BE1')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " 'F1H479523945CABF78273658DIA851CID762D2G586193369712H4E9371H5BD62FA7348E9584IB61C7')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " 'FG2358D918497AB6351E3694BG8514786BC9IFG324581H32IAE46714792C86EBEF17H49C38954F72A')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '8F72E194354A9386GBB93DF7815C75429AHFD86G15329129F3H57469D73H5121532F48IG7H29EA346')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " 'DCE2697188194G35B66G2H5A39DE9A68B3G438D75A96B2674CI1H5956127HD3148FC5297GBC948516')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '256G4A39HD1H953B67G93F82E414FE9821C7839A7F5BD12735D86I814FB95G3GI53H16422C64759A8')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " 'EC7269H418D61G32E9219H4EF3GGHB15F493FC1D97582954328G6A97D315FB83FE72H9141H24I6573')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '9723DA658F18759CB4E4C628I175C91B74868FA945BG34G28CF159213H9EG64E9F43718278D2F1CIE')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '43B15987FF9EG84AC281762C9D5I23E617H4458927C1FG61C84B593D72A86I58615G92D35IB43617H')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '6452397AHGCB861945981GDE263D5CA9F872FG9E2H413812374EIF387IBD561AE4386297F29157D3H')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '974C58B61FA8G2IC45B3E64197H53F41I82G1842G6EICG9B8531F41I26H374543795A86B5H6427CA9')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " 'A48C79B6537I62518D256HD1GC99218E643G4F32I78E157H31D69B79B58D61CE16932G48483A6GIBE')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 29,".
    " '5GA92386D3D6158IB7I82F4G3AE742185FCIFA549378289CGB6451D97CE8B1653A26D8GIBF8179534')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '75A8FD923H36927AE4B9D31E78F246C9E178GIC481265A58627ID3E8G41963BC1267H54I469532HGA')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " 'D53A7962868I52DCAGB1G368I54EFA34G892832IE64717D98215CF2A49HE736795163BD86HC4G2195')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '65728I31DC18F47E29B9DA358674I376EH2A28F13D97557192H64CEDB936AG88I3GE14627A64H23E9')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '5A49F28C7H9GDC16253B6758DIAAGH456329246CAI578539B87F1DB91G8E6437ED963182863142IG5')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '76EC981B428D15G3IFC91DB6785F3I512847748639EB1152HDG963281476IEC463IA58725GI23H614')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '3I6812DEG741FE9382H52347I16I84G31B6552G8F49AC16C29E47817H54C629435296AG8FB97H1534')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '2GE841963A49673HB5638BI5A4GD19F8B3577C69E1482852374IFA5C6728AI421G39D56848951F72C')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '431985BGF5GI63214826H7AD935C1H65974B7268A49E3D5ICG2F81AF48275I3395D61B8G8275I3146')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " 'G86591D2C23947H56A4E1B638I71CB86E9G4857ID3126649712E3H2483576AIC15FI2G849GF18D325')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " '791235HFD6B4AHI735E8C7641929E2AGC648473568IABH1F249357429EH7316CEA24689G6G893ADB5')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '2ADG86C59HI53B14G6736E941289315GH46BF5D21973H2H74F395A8I56B7143167943EH2C4B81E67I')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 29,".
    " '27HDIAF35CDF8571I2E19326G4812754C9HFD8E76I21CFI32H14E7354GAI862978F24E3116B83597D')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '4593627HAHFG1594322138D7E96128I4FE739DC7B5681765381DBI835B9GFADB96CA45781G465H93B')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '49AB6G35873B1589DFE68C497129721D6EHCEFD873219831IB5476635HBD719481697CBE29G15368D')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " 'GB6D31E98E83I6274194A8GE32F86I15C27D2158GD63I4CG2F95183856D79A21BG3984E6694A52783')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '495H61B37261EG39H4G8CD9251F3DI5287A6G2ED1F398168379BD5IHC67D1521578CB649624951H3G')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '75H9BF314F43E17982921H3D76E6C1842E7975H13I26DD9BF57A83AH7265D933264I18G55493G82A6')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '2G9FA34E86DH59G2131352D8I7F327895A6DHF5421C794I1CFG85BI8B731546754986AC2613E2D789')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '14E67H92C386D29G15BI7531D683A28675I457H94B63A9DFC1E872D86G51B391E32948FG7296HC154')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '2C4F98AEG7162EDC98I5H317264EHA423976942FG18357C68954BA369GAB845EHG469123142583F7I')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '9F57D81232736EAHD9A48B3975683G69A254196425CH74BE8G3691D19C72E8656BI187CD38G56D9A2')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '5CA2648I74B79HA3658I65731DBG1892CD566521487CI93DG6E2186HI14B375B13E7F894457389F2A')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '543IH76B1F8AD2395G92G51634HHIE214C763168795D2274FC589143975816BA6E234G98G82AFI453')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 23,".
    " '378A54F92E46279H319B1CF8G545H12694CGIBC75461H6478A35927169DC8253I2185DF748E27613I')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '296GAE8C4CG5IH412641H26C79ED68IBA357E3A74869B927356HD168IA7C542B5G469813134582FG9')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '981273FE43B6ID5A78D57F81392ECI8A6742782DE3F191647B9HC5DBE39G1F8831564B9G97621H54C')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '8AC425967256IG84C19D7163EHB374196BEHFI5782314218C5D679E89F31G42A2G849EFCDC67B5891')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " 'I48153FB726A94G385E37H26I417H45F2319EC61I47BH1IB3G86E4836D9A27ED5B6738197192HE46C')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " 'G95B6H31DC41E9GF82F28D13E791D65798C273H2FD15I95B83A74648365AI2G9B58734161F72I43H5')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '1E69C84GBC7IB1468E4285FG93A7936148BE452HCG196AHF259743B4G389E6A963ED1728H15672C94')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " 'CGE9614288947321EF6125DH97CB4FE93187I13687D2585742ACI683D7AI6522G9568CD1AFE234789')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '3491G6HBE625IHC7148GA2549C62I45C1768A67B4H539583697DAB48G6139EB3E68I24G1129GD5C68')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " 'B4E317I866879E21D393A84F75B5I21G4FC871F83I52D3846B51G985C72A469B61498CG5DI7E63218')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " '183B4EI67BDG6935816E9781DC2EAF872439328D6IA7594G513HBF724651CI8HAF934752C95BGH164')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 29,".
    " '73I28F415E62G4A3IH841CE9GF2943H62A5GF579AC2HD21H57DF93578691CB4429HCE176A3F427985')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '6C41I587279B86431E581G32FI428G96354A5C14B79H646I8AE27CD29G5H316F73A492581E8326ID7')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '61D52H37I3B91768DEH75C4I261945G81B637FH4C259112C95F48G1C28I6457FEDB17I837I8534FA2')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '3916G54B8HGE23419FF24A98C57A56742H399D86537A273B81I54698G5FC21DE21D89C674F32G198E')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " 'BCI841675145F2G3898G63E91B451GD9B38F4C68715I2IH2635D17G68924AE3I53G1H26424A56C798')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 30,".
    " '3157B8ID67D96CAHB56H29E47A3E69A3DB87CAG26H95424859G13F65A8IC472D8B176E93C79D25H61')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '5C78129D6DF93571B8218I4F35762I38D17EHD1E7B69C5G36I14H2491B68G5373F9AE284H2E73D169')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " 'EG3281I64148CF95G2I6257D13HHEI31B647234G8F915617459BHC7281IF435DEA823697396G45HB1')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '7D82C1IF59BC6E814761E49G32HE29F13HG4H6D279E317C18E49F248615G39BC12D96785579B83A46')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '756948CBAA3I52G64882DC1F759B7C1HD6IE9167E34H2D8596B137412EC7H69395H6D27AFG8291543')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 29,".
    " '72D96158C6IC8G5B411854B37FIAE8F47B39G26139D5HC94H526174G6HI23A5E1B36G984938E4A2GF')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " '98CF2D751G5BC8194FF14597CHB372DIE8164AH263579I56871BDC238549AF7194FBG835G6EA38429')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " 'BD3EA79866859CD27AI71B86EC4654C2H7918I3417EF2ABG695843839AFB475GE6349128412758CFI')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " 'A25I746H398736A24EDCF5281972D7HCF5195I31746B86H19E23G4451GFB398HC2459G1676I81324E')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " 'GHD312956613H9E427592F74A8C625479HCA98DB3A756C1G865249EF71932DH1425G83F993H4B67E1')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '675428C1I4H39A56722A9GCF458E8614GI3BC41B69H57I2G38E641793BE48F152819F73DA6487C592')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 31,".
    " 'FAC897DE2GB54F38A9498B1E367145BFIC7863B58GA9D7HI1435B6G2A93D586I58276C41F3DH51I72')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '375128DI6B6A97483E4H9CF5217687954BACEDB317689931H2F574G3184BEF9DI8756123652AIC748')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " 'ABH476935675923DHA4391E87F2BD78E36I1869142C5G513FIG2845827193FDGI65C42A8C41H2F975')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '238479FAE167CB5D98DE96H1273G8D15296C9537DF28116B398EDG3475B1HIF6AI8745328259CF714')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '587241CIFI4A3652876329HG51497583B1FD6CH4195724217FE3IH419F28GE38E37941B6B7FA53849')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " 'C5F91G4824916H2EC728G43E69AF2DE98G3131574692H879CAB56487C2D9165BE9A6387414F758IB3')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " 'C627ED8A918D93BEGF795A8FD3B597246A8CF13G58429B4HI136579BE4316788D72653IA3F18G9524')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " 'H42563A79679ADB8CEC15798D262E67I14C8DA8326E9G9375H42F192E31G68D7FA98425C84365B17I')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '843BF1975625C97A4HI1G58463B15I4276CH48F9E32G17238FA4E9396G14E8B514HFB7392GH395146')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 29,".
    " '17D32IH5629F87E34A358A46GB9DF3591GH21H97B45F35726HC9A42C8F1E947I17D3865246E29GHCA')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 29,".
    " '79634ABHEDHABI576C235G86A499341685BGAEF3279488G2EI4361659DA3H728CB5G96144176BH95C')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " '37D12F95H8FEIC42A71B97E83D68C74A5B691EF79B34849268CE1GG91682ED3D83E716B9B65I34871')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " 'H39B57D615A64H37924G21698EC6G3124IH592D86513G58AI37B4651B79834FF78341B5IC9D62E718')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '8C76ID125B4185GCF95FI3A2478GF3E48912918FC2475B4E791H3645IC7A2861H35267ID62G9H4153')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " 'E46BI7318G13568B9DH2I34156GA7B854I6C4C6921HG5958FG3412625GC14H9387649A5B1ID2HE7C6')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '5CF4912H7D87623E91192GHE643374628I1E9A27C5864568DAI32G843159GFB15I27F34H2G6HC4951')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 30,".
    " '281356I7DFEG294183349AGH652432FAH59G976ED28C1EHA793D261F57D98B342I36H71E83GBAE96D')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '473A2I5869168753DBEBH346791I3G26A845481597FBC2654HC1G93127986E4GFHA542399E4FCB817')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '56B893G14481FE7239GIC4125686E19DH327HIC7B516D27D631I8E435276A8I916CDH572HB71E9346')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '3596B71D8A6GD9H3258B45137IFB74H9CEF16E92417H3AC8F759429CF48E71257D91B83628136G4EI')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '82D73591F3I18642EG756BAI843B97A63D585364GH12ID81592FC75H93GA642GA2F4E98336492H17E')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '297HFD135EAC79284F846531I72G586134291C92H4F576B4GIE1HC97F3825DAD2EI613783184EG269')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " 'B16I48G5375IA2C468D3H57619B1B5897FC46C72DA89598DCF572136A48I572E72316IHDH4IB5G613')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '3581FD79241295GF8CI6G823145DH6EA3B793B17F98D57E9BH463A9456318BG276E9H134CAH472596')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " 'E89C64G21D17B58I6C3FB7A954891BFG5843EGD831692836294A7E43H1IF2577B93H5146651427I8C')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '736B9AD5852148CI6GHID7652133D96128757A83ED296F52I78C4A52C964A8GA7I835F424861BG539')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '4B7I56HACHI3G21D56A65DC8792B8D375691169248CGE573IA68245C87FB1496A798D53224I3516HG')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " 'FE482GI3198C46175B712IC54683427HFEA95I83A42G6FG152984329C1G5D6HH47639A251EFB8D39G')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " 'BC8A745967I58B643141F953H279F5G1B8D3C48F59A722G13D86IE62A38I45G98G51D26C53D7FB18I')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '356D78B9A724AI65381IH2EC4761H39B7E6424G6538AIEF9814G32815642GCIC6B9754819473HA625')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " '539DF71B8GH6125439142H39GEF784C1E296IF32748E152196HDGCFDC9G185251HF4B397B973856AD')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '3GI2H1564A58469CB72F4EG3981F97823D15E439GA28681B64573I13H94F7EBFI5732814427AE8C96')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '41G625I3H8IB74C156356A9827DCE67I1B84D7I328E618124F59C71G9543HFB6H42A7935E2C68I741')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '954C78A267316BE98D2FH9147E341I8357FBC68AG2459E726D98316IC281547817E4F29342539GAHF')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '348AB75I6BEG8693419165C47H221D65987C985G3BD16F7C8412IE461G32IH5EG86I4A23329A58D67')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " '325G918DF76H24E13I9AD63H5279HD1C2567356974HB127A8FE3D94A9B53F7HF8CD97E12G52A86493')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '5816C27DI39D85G2AF2G6AI4835H2C17F954469EH21G3751C49F8B497BA8365F3174EI28E2H963D17')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '452791H6C9F7DHC2513HA2F5749289C1E6745GD698312136D72EIHED7126938H26G39A4591385DF2G')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '352I4GF1H8745FA3I296A32H75D4718C65BIB53G49618HI6B154371637ID28E98G1254CF5D26831G9')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " 'AE4839B679832FG15DB7F4AE8394H36I27A5621CG54I89EG1846B332H54197F749836EA2561GIB3D8')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '519CB86D73HF94721524G61E98C932D7E18F4681395GBGEAH26439H93761B54FE4823G9A172EI4368')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 29,".
    " 'DH162GE392EF9837A4G395ADF283F81I527412GD3H6IE495276AH375B81C94FH49562C713619DGH5B')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 29,".
    " '9C15H7DF264H29A57C57B3DFA9H278F94CAEI16325G84D53G81269156G438BI4C98F21E78B79A56C4')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '486531GI2A25769348937HBD16567E24C91H9HD5162CG31B78I5D6C54127HF98926EC471FG1498B53')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " 'IHA264735C67IE1428542837FA96983E2DAG175HID6324BC176985H26E4C17951C7892DFG9D261C5H')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 31,".
    " '397DBE81FF58931G24BDAF7893E271EDI63856C81B479D89367AEB7549HCAF21I62DE3H78BC7165I4')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " '8GB36519DC94G2A8561568I4GC2283IEAF4G16947B53HED76832197C95B84166A59DG2H342H36A9GE')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '1579HD36B9CF21G854248563GIA5738DIF2A4FH5213791296C78EDB18436G95693G85AD2475I1BC86')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '2861E79D3I7A834256435IF28G1F74E91C28E1BDH369739H72F15D86I4AB735C457F91BHB17E83649')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " 'B98D61C75613EG892DDGEI3286163258G14I4951CF28G7AH2943568E67B49137493EAHF21BC6H954G')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '741586B9CE32I7D1868FI1235473278A4IF5D58697B13F91BC54G815B67I43H34982E7FA786C1D952')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " '24951HF3G73H6ID2516EAG2384I3H4765AI2519C42H67BFG198435IGF853D21485AB69G3312I74EH6')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '725A96D38HID3B5671163HG4B592F45G398115894BG6CI37FH154265G84I31BD19236EH73287AE496')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '5HI7436217F2EA8C493412965HGA7HD65C924238I1675IFE7324AH9A72E483628413F95GFEC879A24')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '548C97BA6A9C256G8472F14H9354CI78E6218173F29D56E2DI1873IE38G41FB678E2A439B14C69E87')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '1238GE469697412CH58ED36I172F58IA2347B4CG681E9G91543B86591B3D78F82457FI3A6CG918425')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '3H214E769579B8FC4A41697CH5BB56I348A7D387156I27I12FH3D54G16IH5B38EC127964F29534A8G')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '826139GED5DI72F3183714HE692ID23G1685A37H652948569B4ACGE67298DAC483FGA952B1I543768')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '9E36A84727A4592CFHF8BD73159G8D169C25659BHCD71231547IFH59G84123F826ICE1473AD7268I5')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '83I42G61E54B61H73IA67C95248B4A978C569E32F48G18G65134B97631I45H2A25C8749FI8D65B73A')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " 'H94G65A2321E39H74F73F241IHEB473E19H6659D82A73CA8697D5253B41I6789F18BG534874563A2I')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " 'G15F29H3424FG3H19EC9HAED62G2G84E31I66A38795B49D52F187358B94736A461C82IEGG39E16482')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '2A83I76D54G36BE89159F14HB7C164729E8CI5B386714H37DEA629456H3B971A3I567248782914CFE')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 29,".
    " 'C29847FE1AGF59C824HD52AF379EI61G24H3D32685GA9187IC456293H71526DB67ID83E145A623G9H')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '37B8514IF1HD976523569C4BH71G24639AH5FC9HE12471E87B46I35FH947213412368GIE937BAE486')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '8136GB945D9FE18273752349A6H23F7914EHH4G6529319158CD27FC64A29E87GHI3F51B4EB14876I3')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '269AEH437CH5D97261174263I8E79FEAB3841CH74F9524523986AG9D5H23FG1673EA98248BA7D6539')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 29,".
    " '5F7AB49C8H237594164198C6GBE21IH5647CEH42376IA67319D582C8279EFD116E3DH97BI47BF1C58')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '1F32E87I49HB73461E5G4FA9328E12C46879D78591CBF96C2HG14592A48563G857BF3149DC6791H52')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '51B67I3DHC48A5279667IC4H2157948251FC63E9AG824A82D63I57I3748FB515612GC4H98B45917C6')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '3EG48F29A9F1723DH52D81I5637615G39H42C4B658A79H79D21E63IBH1F457353489G2A671F35B984')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " 'BED63189G1975H42C6368IGBE414G231856981EF7I34269C425AHG78692CADE453G6A928BAI854736')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " 'F94C25G813519H76D28BG6A45392D75A8963516493GBHC9H7621451E2D3I876HF9A75BC4DGC286I51')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " 'AFB5H3479437962HEA98EG41F2363E248GIABD9716E831785CI264314I57H2667532HA9D8IB41F357')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " 'HA3F4295729G8EC4615467193BH7FE398A2D349125GH6281DFG953239586DG1FA4I72538H7EA34692')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " 'A83D29F57G4E86A93B6923G5H145IA27436HC76E982142D8163I577168D29C54H31E96B7E2I73F48A')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 23,".
    " '3948B65AG7HE1493262613GE8D9D6A273985I32F58DG1758I14F23159642G3H8F75IC2144CB187596')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '374HEI2165692713DH8AB64357IA43I2GE6H8EG13649B926D581376C57H249A924F1EG83GHA3942F5')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '37B165IHD8942GC5A661E49837BG91253HD6F35A489272H49F75315C9F18DBG7H24EI361A46G23H59')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " '9DF7E381253B48AF9G8176BI435E24F87AC91732D98F59H6CE17D247526H39A316I54G28B9HA73EF4')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '169GCB5H4E34H69B712G85149F3D56B97H1CGBC61H94E18934E72F37892E64A4IB186357651D3GH92')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " 'B4896AC57396EG8A421EG3B49681234H96G578526C91DDIF715B83E9D812736631457HBI872FCI541')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '3692471HE748EA9632A5BF83974IEC478F1B421CI68758F72153DIGI48BFE3116395DB8GE2H731496')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 29,".
    " '96G48E213HADB37F953B51I67H4196G54CB8EGH1234692438FI57A5798DAFC238F9EB741D1BF37958')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '81EBFG39436D19H52G9B74536A8523986D714HF7A32E9AG9B4EH361587C9F4BI72F4183536D582G91')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " 'DB96785138A7ICE46263512D9GH19F842G3E7HDA5329FC52G96841IE4367281671528CDI283DA95F7')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '3F9G25H14721DC8569HDE69137B2IA548673847C9FB155361B7DHI9CFAE248717D983FEB258G64913')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '349F85G1B612G3D859HE7A29436896B7C15D241E86I7CEG39416829F75214C84B53I81F73A876D2IE')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '72A68CI5DCF9D2518748E91G36BBI61478358732E69DA5D18I3276DAH3F957273BE146IHF59G28134')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " '792FAE3846134982GE5HD732619231E7IDF8I56C84A27478A26CI58561BG94C7C25D98FA9DA86C25G')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 30,".
    " 'C26A7EH94514H96G238G924CF5AE6B938G4A9381D72F54AG5263I82E761C4H9F8A45I37BI34GH21F5')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 22,".
    " '8EA72964C937FD582162413H75I3629GE1845A8264CG99D78132F5D375I6B1819648B75CE82C71D96')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " 'I8B54673A3461HG29E75A92C64HFE81B739442965C7AH317D89E62DF9215873832I7DE611758C6BI4')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " '3H7615DIBA5DB9G36892F43H1572765C8IDAH4A926573C95G1D682854A6CG2I7194H26C52F3EG9841')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " 'A4F735892235HIA7D67986D21EC3BH51946791768DE2C564C2G81927AIE3684359468AGBDH6B71935')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " 'H6B519G43745CF89129A34B78E66E8BI713D43A856BIGG92C41685426C8A97EEGI624183138579B6D')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " 'D3B51786IH59462G3A617HCI245358G4A296617928E4C4IB35F7811HD9B3675BG51H63I4963E74A2H')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '431GEI826657482AC9HB9613754973FA8542261945CGHED83721962HE16D39G79F5BC81D43A98G2FE')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '518G3I426B7C56481964921HCGEID3167285728C4E19F561I82GC4352FIA87D6HA4579324978231EF')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '52G63D81I398GEA624F14892C573859F27DAI1GD852364B61G35894G8BE61935F91738D223A94H76E')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 30,".
    " '173569HD2462H1CG9E8IE72D3616342EA98G971386B5DBEH47I1C6DI5C167281C75BH6D96H2947EAC')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " 'BG6543981984712FC5513H6IG42FC5427A98291HE346747869A3BE35I71286DA7F34H52I2849EF1C7')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '586BCA947413976HEBG2I45836165ICAH47B1875B4FC92D36978A5194GF382536H295G4AE7B184I36')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '7A45I26H3HI3416E27265C8GD1927F835941138IDB765954671H2CD6GC591282596813GD1C87DB5I6')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '946G82E3172591CF8DHCA64E2791754FH293842139EG6C96752D1882735I61DDEA267C98963AH45B7')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '62793ADEH814BF5739CIE847216CF91752845783D26IA1B4FHI7537IB513846153DHF92G468972ECA')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " 'D81IC7B65I36251GH42EG46H31IE237I4FA887961C54BAD65829731423GF8593F84I51B77IE8216CD')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " '61DBI5CG853748F1IB29HA73645H395D61B7651BGI8D3D2G831I56D6C95A782G28C6491E5A97823F4')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " '71I25DC68DH31F97EB52F3GH94A9C6DB7AH527A835694D85F19B37591FDB873CDH9175267628531I4')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 30,".
    " '476EB91C8AHE6732949324H1F5GHDE362791961857DCB72CAI456891D25CF8G5287AF34ICGF849B1E')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " '837256IA491B84C756ED61G92834B169C5GH3H95G1BF476542H3IA3H9G4E16BA27F38D95FE4I12837')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '587462AI39DC18E276A62C9G584G258DI3A6HF135749294C6217EH9716ED238FBD7C85198352194GF')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " 'C18426I755BG91368D9467HE3216372D1HE9AE8739B46B94F58A3718BGFD59C3FE89247147I51C86B')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " 'I425176HC5738BF9148AF4IC275D61C7E829C92468G5AEH7I2A6347EH134296639285ADG142GFI358')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " 'G46523A89C1EI6H472I82G1DE3661583GD9B7CD5296812984FA3G5CE19F42782I6857AD38471BC659')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '1CF92H74554H13G69B2974EF3A84526G1CH9GA34892E668I53B74AE17863B94824IG5C61I63124HG5')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " 'I5237AF84D1HI26C75763EH49B17C65B94A854983A76BH126D7C9E89G24E16C154FI32H7B3F17845I')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " '829643EAG17489E326ECFB17849GCH1I24F52F1D537H94I56G8123CH6I51274I12F4GE3875438BI6A')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '43F97E28AGA5862IC49B81436G5612C54GI85HC29714F7948FA53B5F9HB7143321459FGHD87C16259')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '7A4FE29833HI147265B658C97D1196C27H455BC8947A6478E1FC9256A23I4GH432F7HI5198G154623')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " 'HF47A35B97956DB3182C18954GF95H23G64A463A8IE27A27654C8I376DH5192BE49C18G6918762EDC')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '214758F9CGE6392481389AFD57246ICB58G1A37968EB4H2E4179361D6932E8GH7I615B43253GDHF9A')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '5AH672394764I8C15B923451F7HI25D87136F4H391527317B6E8DI2E98437FAHA6B754397C41IF582')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 29,".
    " 'B78531IDF4E19B638769CD7H125CID812G65512GF48C9786539BDA1E3627DHI24H19C67E9F78ED312')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " 'G95D61B8381B935F7DC642GHE9167H13D529543B69A879AB857F4C3E79468A24I83217E6126GH5439')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " 'GCH6912454B6C58AGI19524G86CH2GI1635D5648C7IA2931EB47865FI47218378369124E412CE8FG9')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 30,".
    " '645AHG39BIH723461E3A29F58G4431876EBI578AI2463B9FD531879E321D7F884FG59C2A72AF3H5DI')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " '947H23F5181245F39GC6E179D8B5G43A92F8968B7EA3D2CA846EI773B1864IE6H15D97B3I54G23F18')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '9HB6GD15334589A67B6712C54I8CD57692181674BH9E3829A53G64897426E3A2C4EAIG8651F38G94B')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '364975BH178E2FA439I12DC87EF532198GDFID8657123671B4C5896AG85942CH94372EAF3251FD897')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '574H69B3ABFAC45987389G12E46685I4C71B439712FEHBGA8654931283E7DI6576A9DH239CD62H157')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 23,".
    " '175D89BF394C26A87E26HC7E914EB48376911376925H4689EDA73231H94F752G59328DA6DB61578I3')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " 'A57342F9H982GE6341D3F198E72H3E91627D67452C81I921H4G3654BI5H376A165297DC87H36A42E9')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " 'B5I64C718H16972EDC34G58A692HB1C75496639184G2E7E4BFI813932567AH4DF83I1257A75DB8936')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '294AFC785H3E274691176589DBC6CB478519518IBFG437943152FH8D6327I5A1EB4H93679C7FE1842')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '19854GC6B327F9H54165D132897I5AB36874D62785AC9C78I41E26DHI7256A32568AC9G47A34F92H5')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '8937A42FEGE1269H434B68E39G1DH61795321953BF487237584A6I34A62H9EG57HI3D612692G1EC4H')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " 'FBH479531954CA67B8A73E82DI6IFG2458A383169G5DB245C1H769G8B156394463279AHE951HCD627')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '45B617H3IC7F498B151982CE647G93E812465627D91H38AD32F5793B41FH9G585793DF2AI61G5B483')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '5B18349G694762AH3E836I7E4BA7EC162489186DI35G2249G58F13C9HB15FD7214GF8359EF73I41H2')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '3G18645I224F1EI7839H5732DA6783ABF459D25I78F3116I5432GH23H947FAE5AG862394694CE1827')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '4A69385BG9E82A73463GB6E4189B49C8A675871625D3I5FC49G2187E31648IB192G8C56DH46I25731')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " 'DH916732576CBEI8141524839GFI5F8AB7433D1F759H2827C49E61EC1674298427AIH536698235GAD')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '25D987FC181734F9BEI63E2AD871437658IBE92DHA6736GH2391543BI4G8516158269GC4746CAE892')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '51267IC4HGFD3812599384E2167D86GB193593BE4F17H57189CF2DHED16729C627HI3415319B45G8F')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 29,".
    " '231D58FI7EDG9CF821896GA23459B58G63A4768413B9E1C4EB968778916B5DCAED3G968226C45H9GA')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " 'BI514738F768C9BDEA4138FE927453IAB6781GF843529B98576CDAH6D739521937BAE684152684GCI')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " 'AI8367D254E38B16G9276954HCA6GDBAC589C18E9726452I64831GIC67E184214598B73F782DF3AI5')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " 'D75B91F386B98G34A513H65D92G14I82756CB36541G9H875CF94129E67A43H23879F2A5DB41583G96')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " 'FHG1925D3194HCE627325764IA82694AHGC57182534FIDEC6G9281356I248719G1E8FC42HDB137596')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " 'FH3E9174247B63815I9E17D28CFDA5379826327EH6I14698B14E7C1FG23895D2937DEHF1485A6I327')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '6394A72EHH4G625C91B51I3846737F58D9212897A64EC1D53927H6HI3A42G6557B96H13DF1D57C82I')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '94637A28E85A94BG6373BE68D19F97D38512D28519FC735A6BG894HF91E3724175284CI62D3IG6185')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '183G4E92F746C92H51E9BH61D73F78D52C1I4A398G2F59B53A67D82C18645I7E7D13962H689B5G134')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 29,".
    " '481GI5C6B5G92F3DH132F8DA9571DHI27653796C1E8425326841GI8G9BAD5C6134658I2GBFE793D18')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '6I387142541865BG9C72E43I186B89AC6G54571I24CHF6D35G89A291G56B34H2358D71FIH64C91B57')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " 'B3I5HF714167924E8C584C1G926A789D26532563G84AIDC96E1278865C2GD917IB64A835143895G6B')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '5684C72A92GD9613H5913E8B764625C74IHA71H6BI453CD915862784F7IB153E37A468922I1835DG6')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '87FI5C2149D27F1853531824IG6A82C4GE6953G68I12446921E7HC7I56384B1B1F475C9HC48AI2657')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '917634EHBB3F851G948542IG316823G4E16IFA73294855491FHGCB2563G1DI81DH9625739734HE621')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '1975FH4323BF497815485213IG6C16I75824284631EG975IHBD3617E32DA689I687E31DBA42F9H537')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '641HGCI52357924AHF8BI1563744F912873EGABDC569858C9FG241BAD59738686C241E7I795F38D12')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " 'AGE986423C46217EI88295DC7A6B47F1H359H59473A6BFCA29548G7C45I186298562DG3A16B3789ED')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " 'A62348E9GHD5179362973EFB14895CF8D721DH19B753662735A4HI2154G68C9F9821CGE47CD89521F')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '5FI78C12D2G15649CH8DC9A2657318BD69574273951HFE6I7HA2346324G1HI5819F5BG43D7E398126')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " 'E41HGF923B79C45F18836291D5G31E2FI48749F18G52C7BH3456A973D692AEH961HE47325HB1739F4')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '127839EFDE96G4BA388CD65A2796952487AC314I6G285GHB31549695B476C8147C8E1FB9168I23E47')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '2438FA95G561G93B4897H54B36A73D1I65B89E23H74A6AH6D25G39C89D12F7512D67E83I6E7H9C214')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " 'F72I4AC58341E28G96I85C76B14D1E78926C86C25D1GI79263A54H8361B75I49A2DC56H74E7HF91B3')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '6B84C1759517629DH3D3IH5G12659D18236GG6A93584BC82F7DI15BA6I43875374258A9F5I8GF1243')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " 'D2A679853573814FIBH69CB517494G23651HA5F48723I238IEA7463H21F47IE9D5GBH3F161G593482')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '8F9AE7423D15923F8G2GC64851997HE4F2312561C87I4D3A927H65CA2785694849362EGA75F1ID382')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " '26E18734I38D29E716179CDFHE2F5CG92D189G14F85B328453A6I75C6HB49G1A49F37H52G28915D6C')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " 'H26E34I1G7A59H23463I47F15B82G8FE91D3E9CD71F28D16H329757FA48239585913G26D2436EI18G')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '48I5132G6F15B97DC87B3FH4951A4E73B9687H69D13E2392E68D1GC9A8E762452416C87I87624I1CE')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '36D5AB879975C8F4A281B47I63E2564H1IC7839FE7124GD1293586G23648AI554AB9C768IF8A57324')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " '25I74A36H16G8EC2IDHC4B961574C5192876GB64H5IC19817F35D2E87IB4F136423185G9CAI67E428')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '2GH6AD9E314C85I2679E6273AD8432567AHIF91D28375G85CA9624826G45C917CD9A65H259183B46G')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " 'BH54691C7431E8G926769213HEDE74I1H623BFI7438151386259DG74B8EF39115H3926GDCIF471582')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '3EHAD29676A49378B59G28F51C4423H1F57I196572D8CGEH493621285F9A734G4I35H26AC16247E8I')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '61HDBE73I29C8F754A4G51I32F8I675DC281134782FEIH52619C473921G6HE4D15IB837678F53D921')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '745326HI18BC94A6579A6EH7243459FHB173A76534BHIHC2179465IC85FDB17712398DF565D72A398')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " 'E78C96D124I21E73FHA6C248E7I8647BI135G35H41F299A23E67H42839EGFD1516B8D97CD9G631825')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '476EBA83IBC5896174819473E2F217IHD365E43612G89I68735A4B198FDC75BCBG95146H6E42H73I1')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " 'G42HCAF95E61749832C982561DG2149E7CF83IG6BH1546H54A372952IA7C4864GF2H5913831964E7B')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " 'DA5267893782IC16E4F93H54G1252DI7F13H31642HE799GH5312D6382FE9741AIGB43865465187C2I')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " 'BG53468A963DH1I527I81B57F3DAID582637756C4A982823796D1E76H921D5C1954F32G8342EG81F9')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " 'IAD36827EE72A94C86863GB5149489152GC6B3A6479585G6CIH214HD35276917194FC8BE65B98A437')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '56428C1IG798F1E4BC1B34978E6732H19FD5541BG6839IFH534271DG6958C211523F4IH7C89G1BF45')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " 'E6A42789332D1HI765987C65DBAG1I685BC4B38497E165462AC79H352A7F9488D19526GCFGI834152')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '15H29F37D39741E8BFF42G83159E82F49G31A4I732568367H1E92D4A58B3967IH36G4B512G65I14C8')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '31G6I85B4B84513F79E96D72A8326E73A849891DE6CBG7C49B86E195CD7FA821FH9C274524G81536I')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " 'B83A97DE616784EC2I5D92F387162584A3GI9AH67CD52437I5BF185CH76291D794EHA236126394G8E')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '1298CDF57GE36921H46H47153I2476293EHA53I81F247A2H45796C96BGDE318378921DF5E4A836279')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '9A46G28E367583AB49CHB459A6GB48195C675I73FH41263A724H9E48I73A52612395FGHD576BD8913')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '4638B75A9812F95D37IEG1C4268678C4A29E14I25H76CEB3679D81G8D93F152926EH13743157428IF')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 29,".
    " 'BA97H5463H7426C519EF3914HGBCEH942176721386IDE496G5A2386IG53D8214321I8FE7AHE627CD9')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " 'HID153F272639HG1451574B68IC76B5DI3A84E8C12F7I9CA768542B7A98543653DG2F891689314BGE')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " 'A3B47958F759H614238F45321G9257C61HI4A3D2I8675I86D57C216A87D592334G982EAF29E61C74H')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '218DC659G4735H92FAEI6172834G6E943A82A42758C963H9FB1457CBI65487A81493G62E76521H94C')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '192F43E87D68I75312GECA824697648359BA8CA29G5462IEFDA3784582163GI6BC7H91549A75CD826')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 23,".
    " '6D35A9HG2AI82765D37254HC91623F19E487781C24I6E5D98F7231C21G54968859F1B43767D398A5B')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " '4F3I2HE717981E462CBA573FD898572ID136C6A587B499B4163HEG7A26853DI43EIGB81669HC41572')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '91562G3DHF23DI8G517H41C56922E67H1DI33175D9286I48263E7A864E79AC21GE83B96432I41F857')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '258CA7D969GD265813613HD9E725F2971HD3G8A4C659B9C42E87F112473E68IF58A2IC4739G48F125')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '489E3F721FCG42159815287I36DB6G853194354AF97H29A8247FC53GH9A56D221EH4697CD96G23E81')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 29,".
    " 'IC1268GE48259471CF64G53A2H93G5HB6A49F14G93E82HIB1E47F361748C59B4EI2FA378328I75D16')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " 'HC4B59G16G95F13DH226A78D95C1I73H5DF25C42FI87A8B64173I554867C92A1BG958346639A42EG8')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " 'A94682C75BG8345A9F63E1IGD284539FH21G6827E14C9IGA2435H6GBF8D9531913567H2D854C1B769')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '8BD3I56175G94F13HB361H2GE4I1489FC572I2E817634673452IAHB56DCA789793258A4F1847IF2C5')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '75B49H36114IB6C7853681572DI2D51G68C9H31924F577968CE4A2F23I84E175183G649BI7DE21F83')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 23,".
    " '7DI63H5211B69548GC58321G94F21G395864639DH7BA58E46B1739A73952DH65F8G41392D92C68A75')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " 'F4G2I351H238E17D69A59F84273862AC49757D1925FHC3IE8674B1721CE64893IF87415B54H9127CF')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '1H25C79D6634BH971EGEI146283DG8329F51C96E4AH72521H6GI342AE86479C96C1BG4584783956AB')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " '921E7CHDFE87D1FB396C49H2751715FI4C828I31EB764D2F87CA952391684EGFDH37592151G24I368')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " 'A7E294C68342FHG5199F81534B7GH14EI6324962GC85AE32H16G4981C527I4F725IF413869D38A27E')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " 'A72I38E6456C27491H489FEA3B74B13E96H7H59746AC276CBA8ID529C84571F481FI7325576132H9D')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " 'F28G59D311E764CH2I43I28175F9HE2D7316312I86EG4FD73A59281ID56C872735298DFAH62A74E93')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " '1346BH59GEI734A2866285GI3DAH79241C56634GEI8A2A5B8637949H34F57ABD7E12396H216IHG435')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '9F35B41G8H57A639241429876EC65278A43I38I64E71BDGA32I568C96BD7H154G85C12I6B15H96G34')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '458B7A639GC1E69H42I2F34815GA658ID723BIH35741F734261EH931GIDF5826HE123974492875FAC')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '7831B96544B5687CAII1FE43278H4G516I32296GC41581C58B9764491CGE268573H62I4AFHB491357')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " '9D53HB176278651CDIAF39D7528451G6C298823E94GAFFGI281435F17E34H299HBA6G43535D89B7A6')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " 'F85213ID74C79F5218B91G8DE634EB7I813619635DH7B8C71B64EI56D3798BAG8I521643312F4H975')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " 'C21G4I586DH9516B737F52C81D9B6C8759147589D13F29A432FE8GFI84E21C712E63G89447389AF52')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '9732651HD2E4CAHG96FA8G942358BFC19457439EGB681571846C2I698G3AE42127H4EI6CD5C962187')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 29,".
    " '81I6374BE42FEAI378G53H42I16A9C28657DH52G43I6167D19E23H961G48CEB2CD69E1H75873B14F9')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 29,".
    " '7268E14I398E24C6G11C47IF5H2A4B96G3853I85B4AF765G3AH249BAHF3D579G39852DA6D65I71823')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '6C5984AB7G19352D86D82F1G539359872DA6241I6E87CGFH1432952DH59C7616C71B45I89E18GF3B4')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '8ID5G1F231653BH9DG3279D65H11H234IG65E74F8129369C27E41H218DCF9574EF71983BG39852A64')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '7H92345A6354G1FB89621I8EG34845A2C96G9C76D85B12AF57I3486G1D5B398492863A7E8EC1974F2')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '4FI758231823196E7D571CDB6H9A43H9E672F89742C1EB5GA638943A75B698DIF84C725142591H7CF')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " 'I4867CA2EE37412I6812F95H4G35392HF41787615D2ICBAD739865GFB3I18543897D56BAE416H2C97')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '5H34GF91264B31I58G197825CDF154F37B9H2389E17F46GI482E318DI76532AA25D93H76763B1H9E4')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '79D623H1E5C68G129418B4EI7632F8537AD9317D8I652EI42168C7471CHF952I6H72E143325941FG8')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 29,".
    " 'DC7HE1926E6H7BI14C9123465G871854CB6I9526873A4D6CBIA8576I2374A85HGE291D361C4FHE729')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '8I14G635245792C18F6B3AH59G474H91CB6E5F98GB3A423A54F798189EBGF34B35648G91D67C19H52')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " 'G54893AB6C2H61G954A69E24G38D7123E6HI2IF7H1435CH54I62G15429673AH879A4CE6261C85B947')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 29,".
    " '24CF87EIAGA5249C688693AE7D29FEHG43128235I1DG6174F23I58729438AEF1CD65798B586BIA437')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '375I2D8618FA537942429861ECG4986A72ECG53B84619B1F39E7D8582749ACFCIF1254G81746HC9EB')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '613285GIDI75C64182BH4G193651EB4F937863725H491ID8173EB6I37546H218AF7BI5D345283A69G')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '1789FC2E4DB3A58769E69D27H31CI2H47516681395BG4745BAF39872E6HA43994F53281G18C9746EB')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " 'ID38765121254CI8FG76825AD9CGI8B341652E16987DC3D61G5982329F5G481E8D9A2376617834EBI')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " 'BHC7491F5179FBE843456C18G2IF9H524C1GE1D937B86237FHA594HCFD529714517IH3629721638DE')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " 'G19643E82358BA9467FB48751C92IG8513F483162D7IE546C9G21H9CF47512H572AH3946D81962GEC')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '1FG25C49H84C6I157BB95478F31849FB1375C6G958A241523D7HFIIH2514G36435G8F21971692C5HD')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 30,".
    " 'GBIEF8134A4532I76H8F34G15B9D12897F5CF83D52917G9E13F24H9HE3D12762C4EG68IA617I82C54')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '4A28E93G6567DC1B98HI3267145E41I87B6337FA4B85I928536GAD62D19E73HGA5F83924389D7BF51')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " 'I83GF4B5127D1596HC5F13287D9145FIG832968C12ED7BGC4859165263AH479DI17B583683769DA5B')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " 'AGC869245246351HI78957DB316632I1DGEH97D5HC162E8A2674C94873I1EB6FAE72843992365DAGH')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " 'HDA25793663948AE7B57B9CF841674A8EC9B2589FC1471IC4276H572IEFC418HAF794325354B18G69')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '8E46297A3B16C874593G91D586254GCHB19F1I26G58D3F38I14BE7B38D71I65E6D93H72179152F48C')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 29,".
    " '26C859GDAIH14G6523547CBA896AID538672367219HDE285GF4913316DHG92E7I81E2FC44EB63917H')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '234FHI517A9E732684876541ICB3F1GD2895429568CG17EH31962442C17695H9EF8432AG187BI5D63')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '9E17F4C826378EB4A982439A75F52641GH39G48I2C165I1C5F8D7264CAIH27559A274C8F2H76C51D9')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '186B45GI3C7E8A964249B37F815IF841735253192H4FG2476E39H1FC982A57DA54G9FB83G28E34A69')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " 'CD7EH19626B89D75C15193624HG61E739D2HD92A85G638736B4AI5253HI61G481I37425FGDF251I38')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '214856I379637A45B85GH9B34F1DF23GI1H513I85F24G785A42C9679C62A54HF81DIE37225D83G61I')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '45H91C76B621G4H9CEI37E62148AG42358I62F91845GC38579F42A581F29C47D92357H1F6G38A42E9')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 29,".
    " 'F27CA9458EH97F43211438526GI7H59362DA2A3HD59G64IF7B15C81GCHF2E9465B49G138984C15BF7')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " 'G95328D1F3HA6549BG462AI73585CB689147198DG52367462319HEI738E4261E62719HDCHAD623E79')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " 'E1374862I6742C98A58I26A53G4IC64H5271E2GI61D83D81B37E69A5B86G3943IH14B75F74F95312H')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '8369GBED1A57F4382924I58A637294CF57185A67I84C23G81249E618345GF2II7E26138DD62H93G1E')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '395F14G28D6HE279312A73IH5F496G53B48A3857A42IFD21689GC5HG31E9246152643HGI94F87B153')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '5937AB6484H15F32I7G26984C1E3B69814EGA49C758265G8FD2193H7I235A6D6ED71H93B2314FI857')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '648GB53AIE9C814762127IF34H5B56H34197938B71DEFG1D65I832472IHC561FHE127349391546BG8')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 29,".
    " '312FHI4G58DE7326A9F9751DB38196547HBC32GI8A4564HE3B6971G51B34IFHB9D168573863GEI142')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " 'GF8CD59213591627HD42A98G36EF54287AC9I71D3E6282C81I6574493H7B5168AF5432IGGE2F19H43')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " 'A7B9HE463943621E8GEHFD37129H51F97C24D9B3187567F3254HI121I5D67C88C42G916E67E31894B')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " 'D251I6CH7F37258D91A89G34625EA9H632748G49AB563362547I1H75864A93B3BF78914E4912EC8G6')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 29,".
    " 'H97E6CA2436A47BH5I4E29A83F76D52813G99175C4FB828CFGI54A73241H95FA4E296G83H96GC5124')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 23,".
    " 'GBA56943H9C81742FE5468CB1796EB9178437835426IAD91F83725CI5276184D17H59C262683A49EG')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " 'AG8I3B654346H75I2192E46187CH167B954C7945F32A8532A84GI649G3FA28565BD8G13I3A82596D7')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '9C5GAD682GB69835141486E23I7458BGA369CFA4E9872279863E1D8I7146EBC63E29H147D2AG35I86')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '912G86DE3DHG95C2616C54B19873B71F9548849E72C1F5AF84327I63427AHIE1B56I8734GI8C54A62')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '1I84B675325G18C96463497EBHAB7A98DF3EH36715D294E93B6G1HH19362E476G25D83I154CA9G862')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " 'A28349F574G36EH912F5IG21C8497E86CB1DH6A24E7392431I78F55C67I14H2A84526C9797B43H516')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '5DH9A7326B37DE68191FI8C24GEGF9832A5432A574FIH54HI167232956714HCADC9827656873ED291')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " 'GF21D983558D37BI61391EF8B74IHG3264E1653DAH7294129578CF298514FG3AC72I68456D5GHC1B9')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '4B3189756856DCG19219752FHCDE72F48I313HD7A962EF19C5B47839G86E21454827AIFC2619DC7H5')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '7E42386I16A39748B5298E1F743E49A7C82F13246H59G8FG9B513DC67D8B915B8IC51G464E16G9CH2')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '51G29F43H49H1CEB67C26784IA5GE46293816298AC574831D57BFII63AD2875G52I8634114H57369B')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " 'D18B93G652E78641C9963EAG2481E982D376D86573I1BC72A9685468B53A94G79564H32A4C17BI6H5')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 29,".
    " '1B35H97F44H61739BEE7I26D38137H692DEA5IA748362642ACEGI8B3G94E81685DF1GB399A6823D57')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " '9A86C75B44EG9HB163623D15I8725F87A34I879CBD51613D59FB7HD82G93165G95F41BCH3F18E2749')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '37429E86AH29361G45561GH4B937C61485B95A82I76C442I3EF17HI17F83D5245F17B98C83B9DE617')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '8E64A327914925G38FB7C869A4EG91685CB4F2ED319784387I265A9CH14B56G7A45638I2E269HG3A4')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '827DE3691FC5971482149826EGC17B56H34I5I674C21HD389AB76E2A6GH4935854329AF7CIG6512H4')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 29,".
    " '9G4FH1B5351FB93DG88C24756197CH41659B96A8BEC4752D3971FHAFE82934778963D1EBB43G5AI86')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '327154I6H4F1HIBE3798E63G214G4F293H1E328AED6795I18764B3EG94C26812167H5ID3C48A69752')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " 'G6A4C5829594AH26G33827691DE372IAH54FIE6247318814F53B9GFE32H41I7D2A76I8359G85314BF')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " '3B98A57F4F48I7C2A51EG4269H329G648A5C36D1EB897518C79F42I82D76531431529GHF7FEH3A29D')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '765B9D81CHIA3765243425189FG372F58A49419G3BF58HE6D917235H69C74211D3265IHGB7IA84635')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " 'D69E3728117C62H45I852I41CG67IB653814316842EIG4H5GA92F334H17E9BFBF5934G8119762HEC4')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 21,".
    " 'E3F849127194G25C688271C6DI52A59H37649H36D7251674E12I83351F98D7B47I53B81F26H74A359')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '986143GEB4AG2H5639352IF7481294835FG1C58761I42176BID835467E2H31IHBC1965745A9743FB8')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '92H37DA56AFD9E2873753H16B49895BFA74323174E69H6GD938125E82417FC9DA6C8952GC975FB481')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '1598F37B48FB4GA95C7DC295681916DHG532EB8139647374526HAI29864AC7EC1F78529445GI32A68')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '952HC6GA4DFC17528I817B49635128C4E67I9567283ADCGD961582B9C567481647HI15321E8423GIF')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '17985F2CDH3421GF5925F94C87AE23I67D8174A58BC9F6H93A47B56A87IB3454G31659B8E92D38167')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 29,".
    " '435A6BI8GIHF35G14B217HD95363782AD659BFD795H139E13684GB89CGDF521471528FCI6BE193784')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '493AB56788G1693EDBEF2874C19E8I71D36B467B3IAH523A68E94GIC684125775D9BF318128753DI6')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 29,".
    " '142GC98F573E26HD19986541BCG978D513BFA46C92857C52FGHDA921358DF9G9746B15HCHFE793124')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " '1B78C5964436I27H1598E1FD723D98G53F1B56A2H937D2C7641EI858F24I37AGI31E8FD2D12C76H59')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '453G9A8267F1258DI39H24367E11DE9F8372687CB5AD932I17D865BHI6175CD57493B81FF13E48B9G')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " '5G63DB819842691GCEICA75862492175H46C584B63IA7CGF419582A35697B8D4291EH3G6HFGB43A95')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " '1F92H53D78437A96E275B64C18I89CG1645B46GB8593AE21I34H67I785C4F21CB6AI8E744A52GF398')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '97A2534FHE2HD619734C67I81B5637E1B8948A5F49BC724I38756A129CD5GHFG8D19F352F53H72914')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '53H2AF794I2A475C86D67938E218EG94A36B1F92EC7D83D28G61I5183F25D7969G83D51225471I6HC')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " 'CIB7A4658756I38DAB8D1F5B793179426HC5F4E381297328EGI416543B6A98G1698G45BC2HG9351F4')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " 'DB93517H6358GFI2146G18D2IE3H35F941724918G26CE72F13E48I91C54G268587A26I43BF4C98517')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " 'A74B69H35256C1HG9483ID5762A6937EH4218GB4615395142I37FH91G38F54B6D51BGI83C82945A76')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 23,".
    " '8195FBG3D62C48G91574E19C286A27345I865I62783D1438FA95B769825147CA54G39H6B3G2HF4951')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '72489EC6AIHE3162471362GD8599384G65A26BD531798715IH2F43157B8C649D621E9HGC3IH467521')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '489B75A6C5138D6GI2GFB319845354816I2G67H92435A921EGC6847C2FD8EI1185B39D674IF1572C8')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " 'DF32I1578971548F3B5H26G39D193GH146EBH26C5971441E72F83ICD6G2918E2I71H54F3158C64B97')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '127E68CIDH4E239716396A7D258652DGC819471958FB3IHC612547231945GHFE84CF7192G6I82A435')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " '6A25I87CD5341BG8IF798F43E2127E86134I619D7CBH583D95B16GA83457IB69E23FA7484G62H93A5')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " 'GE39A42H624F8EC791H19F27453128C49F75367EHB9A45ID761238D9G83256AA25679DC83861DE97B')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " 'F912385GD2GE416893C48I7EA26A6C782I4552793D68AHI46517C28B63E74A9749A62C5HE1C48926G')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " 'E916D87B33HB7154F94F72C95A8932H1F475A46E27I38G8E394A2638G2541FI65A89C27DI4B67A853')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " 'A4BH5369783F72I5AD795D16C2H4GI3852A6B68471CI55319FBH749347FH521682153IDG1EG249683')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " 'FG1829DE3B34576I8A9583DA276GI63842151586297DC432GAE68914B96H5373I54178F2H6GE2C194')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " 'H32GE1964619B43GE87D596812C12H59CDGF36E47298AD79H1F532385FA92471248C7EI6FIG2543H1')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " '9BE8317DF1436EG982F87429A35493AEH2678BA7I6435576B4CI1HCA9F8257457DCA9B688F27E43I1')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " 'AE6948237378251D9F4296GC8154658IB71CG3I16482EA82C57I64E71F89C249H35D26A7BDF73159H')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " 'A28C6EI74D76B89A3539E14G68B54B8C961G6I75A23488A37F45B92917564HCG6C82D951D58I3A276')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " 'HI6D23157G35AH6429421975CHF3A2IF8745957314HFB6DH7E21I358963DB7A6G12IH54CB3D517869')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '9831F4BG52A67E93847E48CB9F1312658GDIEDH92G16369G14C52842AH96E37F75D31HI2389B75D16')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '631294GE874B86E19CE89GCA462I62587ADC358BA49761GD39625H3BF41E879D87FC95219158276DC')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " 'C97A65H248B54G3196DA6B98E7394F71B53823158DG6I85GC6I1242G14E3689948FA7C526C59827DA')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '839F7DE12642A8E73I5AGC298644537982FAHB7516493691DCB7581D53269HGBF8I743E19731HE24F')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 29,".
    " 'AFDH7523998314BE6G7256CI1H46B84EC917354719FBHI1G86B543C92GHF5418G14C5BI6DE6291378')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " 'F82AG4953574IC8621A39652DH74I58C72A62AG45F3H9368IB1E747FH52I341195843G6B24C71F895')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '76429A58CH12C56G4I3IE4786129G63B541828C1946GE5417HF923H57F42A394FA9C8527BC9157H64')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '5687A43922CG9851F49D16B35HG83F125DGI7913DH526B54G96A38I57F41B8CD13H52F798623GI415')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '1ID63H72E23F59G18D8571B46CI8A7B435FI9B36E1478E46I78312951D8B376G62C19H454HC7652IA')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '358I46B17129C75F84GFD12839573DE2A86926A93H5DG58I647B311I24736H54E38A67I28G69EB4A3')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " 'D8B56I17367538A9D2I1CB74F58C25647IA8497A3HE261HF5293D77C48E129621I7F3H5D86E49B73A')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '3H95G4AF2G56B18C4912D69C75HG31I46B58HI51B34F74F28G53A941782E69C93267D58AE86I31247')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " 'A68C54G92927FA8D35E3D72916H21983E47F346GI1E82HG56429136D39B75H187915D2FCBE1C86D97')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 29,".
    " 'BHI643157746EA83291C57294FH7254C18IFD8C9621G5916HEGB43C68E7B914BID83165G57AF94CH2')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " 'CI8652G41745HA962312637D5IH173HB4965458C96BG12FI7E184348F23I51G5C216G98DIA7D8E632')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '61782I45C834AF52I7EB9374186I36B41G8548BGEC6197AE6982D35923F41G8378IB1E46DFA857932')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '89D23765AC25916G84167HE43B9C28G19E466DI85C27A715B4F9381F39G54H2EIH4321F74726HA59C')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " 'F4B8I7315G58FC1294319524H6G7E6B39AH4813DFE972I4B781F35528D7A96334I5861BG1G62934E8')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '957648C1B1C6B5I7482H47135I64I32H51G686B3174IEA57FD9832H6I72A53452398DFG147A36E928')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " 'H61397DB52DC581976957F4B1C82GF58I14C4CI1F28E758A37DB966529C87A4G9H614325413GB58F9')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '3A7EI2468HEI6432714621G89C582D17F935GI6325AH435A89D627G812436E99325FH4A7E46719B8C')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " 'AH4C975629526DA83G376582DI1D2F753918193BF8D75758149B6CB71645HC95863AI724ICD82G615')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '576489CBA3DA62759892H1CE674258FIC714GC6412H59DA9857B63H42135IFG1759FD283CIF782541')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " 'IAB467C58643E2H179578A93FB4AI4GH65233529A47H686G352D1I23184E679D9EB6G8317H6931BD5')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '356I12G4H87AED32692D97H63156874I51B3AI27C845645C16B89G264HCA579IAG6B5384E38974F21')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 29,".
    " '567CHI412932741HEFHA4526379B5F834IG14GI16528318CG9B64E19E62H74CFB731DE98438I5GB6A')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '32H79E64AF4E18C29717I26435HIE74128C6D32HG6519F81935D27B64173E89G51IF83248935D27AF')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '718I564CBCDF1HB9755IB3GD618FG12953H48546CA297B39487A56549HFC1B7G23419E688F17259D3')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 29,".
    " 'C5DH7291F9814EF327G26A93EHD7412I85F36CH74E21I259CF18D7ABG43E689864AI257393E678D1B')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '7AH326954432A59G86569D8GC1B1FC54789B9248613GEH75BIC641D31285F792IH6175D3756IC41B8')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " 'E36I14B8784B75FA3I9G12C84564F237915HE17D28F9338I16EG2D74A6258IC3H59G4261F92HA3E47')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '3E4892FG1782A6D3959AF753H42B8ED3I167F7CB185491945672CH926EA37484E78269C1CH1479FB5')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 32,".
    " '6H74C52I19B57AF8C43A42I85G6G58A64C2ID6A39BE8G93BG8E64157FH1394BADC259F78829D6GA53')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " '36B89G14EEI74A3FH24HA5F273I5A82C697472F94E138I4C817FB5G8AD59623254361H7I396BGH154')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '1594BH673C28617ED97DF9C52A82H59DA73F7FD83B195C91657H24E94812C67B86473I5A1735FID82')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '4G62H591353I41G68218B93F57DC24EF7A981I82D37F5G65H1924384I73B65AC2AH56974657DI13B8')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " 'D81I32F756IE8DG213237A56H4926D59381G579A6H324381D726IE1593467BH48BGEA9367FC928514')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '6IG42H15C431F95GB85H23A7649769E14H3BH4C27I51612E86C97DB81CG6945357984AF2DIFB51738')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '1D89E73F29B3FA4785765H2CD1I61DH25793E7H13I24F392647E8A576481B3IH9A3524672C4IGF158')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " 'I65428CG1314E79286BHG3164I5853619GDB647HCB195A2IG546C85972HD13F4BA96C758H63571IDB')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '9F18B3DE7834G5A26925G49F13H385B49176D16578CI2IG26A3584G1D6325IH9231HE647865749CB1')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 30,".
    " 'CA26H97D5D6I73581B87EB14C9642H95C16G6912D7EHC75CF8A942B96871E34AE8324IG6DC75FI128')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '4I3687EA2B85I3A74617F45B98383F27D95AD9G51386BB15H69G34AFH7D93253296E81G45D73216I8')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " 'B1863I5DGC9G42E816456H7A23ID86G2C1955GI16H234123I45FH78719643EBFDC752981592CA876D')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " 'EF874123I12359HG6D74963B15H1H46759B3F35289471I27DA3E86352D9G81F9A68E23D7HG43F1295')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 30,".
    " '63B1I547HIAG846E3B458G2CIF1859GF32D1B74158FIC1CF29D875384916EBGGFI425381512CH7649')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '543B9G861GAF3842592896157CD679A5B438EC84971624B1368IEG7A6C25IH4H43IG1625E92846A73')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '29A86C75485C71D6BI76D95B318E47F12938286937ED1AI34H56B74B61H93G5C95472A6HH71E3F249')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '1D52C67I8FG2E89C143H94A7256973H54F2A8D12F39E7E6B79184C562C1G48913H495726I74F28A3E')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " 'EC1F48I72F9H172C54742E3I6181B6C954H77D38215699H54FG1B3219G5D86C48E23F91GC76891B54')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '6H52G14C91I43F82EG7C29548AF35B19G86D916H45732D8G6231IE743I16E2858AD2C67IBF9578C41')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " 'D15C62H7I8B34G915696G18E32454G13F2I896A5H2G3DB38D79F51721IE3684C48F17B95EI68D27A3')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " 'F53921DG8827C64I15A94E7H236A395F478B2GH13I45F6458BG9AC3968472AEGHB591643451CF2789')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " '78325D61I6EB139478149F8G253A98DB5C763BDH6G59A7653I14B89CG8425F1286G15I43E1D9CF8GB')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 30,".
    " '39B5648AGGF8132E94145I7H32FA2IG83F4548G25691C563DIA2874E12769C8HG93D56BA6C2HAI7E4')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 29,".
    " '58A42F97CI64731EB832GE9H16D265A34G98DHG2I6153I31875F426193D28E7HGBF1E3494537HIBA6')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '736541BHIE9D238176182I7F543692CED8174578FAIB3CA87B9654468ABCI753AE749682297865DC1')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " 'E3D69H21G8G25A43I669A72C584956C41HG2A27F58D39DCHI721657831B54F994A76328EBE6HD9317')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '7629A8ED3I58C46A7B41C72E98F854137B9F6A32ID587B79E68341325F89D7176A42E8398I41CG652')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '3A98E46B724G96AECHHE6B7C49158296174CG93DBE1866AD38G529B35178D9F6G93548A2148IF2735')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " 'C72148EI65I17B64H36H45C91G2983B6G45AF52A4893G74A39E82F619825GC487D3FI21EB53D17968')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '7FEB198432H93D56G1143F8GE2I172594FCH9FD813752358G6B491CH19264EG426E37A98I75HA42C6')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " 'F2E798314841BC67I579345A62H439E8BA675HG61ID2CB16C47E892G18539DF964A723588C59F41G2')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '2659DH73AIA4237H65G38F15D9B8734961EB1BF58374I5492GA863519C87F24DGB6513983H692D1E7')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 30,".
    " 'FHE1942C7417C8B659293GF5HAD5239784FA19HBDF57C6DG531I28CEI812746821GFD935476C59AH2')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " 'A98FEG423CB68417957E42I3FA8761C8B5499H3154FG242E97638A2149G6HC553I4AH26GHF753B149')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " 'CD57618I287B439F1596A2EH743613E7H92494G26A58C5HBC94F17DCG2861591563I47B88291GE436')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 29,".
    " '195CG4F82C76B89A4542H1E6I3G9D3GA65B862HD537915718I23F483A46I2575F78C29ADB49G15FHC')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '2765891DCHAI6C4572543AB786I9FD35B817153DHG9267829164CEG21495FC8CIH26AG4565437H291')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " 'H46A3792591G4EB38625C689GDA4IB7136587615982DC538DFB9173845GI261F29134H7EA7E826C94')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '4H9GBE3612358617DIGA63D985217693D25H3IDEB817628E16749C592FA7843DAC982657678534IB1')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '4182IC657G9B685C14FE3147BH98625CA749173429HEF5ID768312IGF1243855389672D14B1HCE976')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '1C8D26GI56I25873D1547CA92686ABH47359G59B634184H3951FG25GA26398493F8GD12E82419E7CF')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " 'BAG9853466392GD5815843FA2GI591873DFB428AEF79C6CG492158FE8A29734942C67HA5G13H4EI26')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '719C68D5B43H7BE691EF24I18735HG9C612421384G9EF946BA53H7F4AB95873C82A7456975963H12D')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '2G49E38A6698A74B35CE128F749F37E8249152I41G86C4186IC5GB12H365G4I7E69413H29C48BG165')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " 'A32476H95784EBI16395F1C8B4GBDI651387671HCB49E3857I46A2IFC71852D2D8IEF31G571423H69')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '5B4876CA93G9215F48618D3I2579432EH76185A4679BC7FB193584192D8G635E34196GH2HGF325ID1')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '7E63AD9B88A39E24F74B98675C1F75A832D9341G29E86I82F4571343189G56B675B3D1IH29H15637D')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " 'H1947CF2542F591CGH57CB8F4917ED19836B2137648EI869C5BA47537BD19H6I42F87A356A8935G24')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 30,".
    " '483FIEB71AG94285365F23G1ID88D9756AC2FE2813794G13BI485636H91D52G9DEBHG36AA2G63E489')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '4BF7853A939E26187D871CID25624159GHFC7E84C6912963AB85479G865D13BF23A8954741E7326HI')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " '623E4H79AIEA7623488749C1BF58C41F72591GEHB9634629543AHG315D86I7BB87EI3D16D9F712C58')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '185GD63I24BI31875667C95B1DH2GC96A45HE6AH7D293489235GF1FB4H375199851D26CG317EI6824')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " 'GB94863516352A7HDI418ICE67269D51CB7HCGB98FD515H124G36IHFE9371421245687IC793AB4856')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " 'D8FC9E7121B58F74I373914BE6HBF71439E894A258C7F3H5IG6214531679H2D682E147C9DIG823651')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '6C42H7519E78169B3DB19C54G8639B14F7EH8A675B9435478I31F2D65I71823C8GD2569A92163H47E')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '471IFH3526851C27DIC9B5741867D95BF8ACH53IG14262FA8439E7195FC7284364298EAGG2HD15639')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " 'D157B96C8HF2D53179973H61E24H5294GC6A3I1FB57487D61C82IE29FA7C58D51D28693G38G45961B')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '5F49832G19G2EAD63831H72645I85G6194CB3IF427851241EHC9F7726A95C481DI2H3765835F74AI2')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " 'AGC2856I445239F17H968D17E2CI2F3485177456A98B38C12G56IDG39HE2461E64I31B87A8B746C5I')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '58A63D9BGIF48G25C12G39EA486D9B71635878632ED1I135H4I6278FEA73249147B9H653C92E64G1H')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " 'B968CE714AH7649B354531729FH352187FD9HI6452371G14FCI8255G1428IF392D76C518C86EIA247')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '54912H6GC1FH37429523G9FE8D13I2HE4G1FG81632D5I654A79C28287961DCE9435BG816EAF483792')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '8532914FGD71FHE3292I6DC7518CG298D615896AEB7C41E476C98B726EC8A49513947B6HHD9F21375')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '3D5928GA69F27C15D8H17F4E32963A8742EI49G25F18C2589C1764E83D6219G619H7532447B19CE8F')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '8A6729E34CG5D6H129D29C51F87157FDB398B8C95761494613827E2H1DG39F5GD65I18325938F27A4')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " 'DH12E7936E73F89B41F92D13H57728AF354I1CF4958B79D52G81C667BC1EH9431D96H75258I72436A')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '1758I42C6486B3EA97C9B17684EG82F53D1936I74A528D51928G6C96G54H32A8EC91BFG42A46375H9')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " 'EH7912C642315FD7894I68G35B147H659B3AF92C1H475A3E7429687I61238D5153H4GI26B8D659C17')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '7352F84A9A46957H3289B1DC675H7B1IC546469285GA35C17F4289CH4621I5757139H62DI26DE73A8')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " 'A74H96E3256IC1B74H23HE7DI617839D16B5A2F8759344E93B68AG41I26G35H2E7DH36I1F83A95742')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '4753FBIH18AB7I4536CI6E18247G59834A2F381BFID756BD751839213648EI7F4G95C1289H51GB463')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " '5B89C174613D72F5IH9G64E8213H5C462A97641IEG38272IC81F4521IFG4385D65H13B798CG59BA6D')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '271D5I683H34627AE96IE813G4B937AFB5484AE78C29626895DCG131DHBF795IF25713485874C9AB6')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " 'D6G52891C8537AI4BF2I14F35G81HF75439234296AEG8I57C82A46671B39HD5B94FH513783E71D629')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " 'E1G9268D338974A62E2465CH9A7CGE281D692I45FC81786A47I32E6I21547C8A38I72D56G54F83192')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '856179B4C29D53F817A3G2HD569CIA5287644B87619E3756IDCH21DAE987632372645AHI698C1B475')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '13H42I75F9D73651B86521H7CID2936478AE4GA85I23FH65B13749IG1C82E64E82F94G1C43F57A928')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '5B46738I189F241ECG7319HE42624I18G35F758463AB961C2EI874D15968G32I82C7EF1DC67A4B598')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '8D73529F1312IH65G4E9F74A83BB1I47863EHD3165BI7657C29418793E8D126F5A7294382H4163IG5')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " 'IB3145876874269AEC1E68GC9D253DG826199B64C1EH778A56I234BI745A3F8645C9H71B318F27D95')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 23,".
    " '5387D9162F24138EG91IG56B438H95324FA73D186G952G269E1H439EA27648C2HC41579F6743HI215')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '1D86E72399FC4285A757B1934FHD85G63921139BD57HFG26I8A34559F87431BHGA3526942C4FAI857')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " 'E84297F31A63H45I279B736A4H546I15387B75B49HF3A13H2GFE943D57B89A6BG6519384819F4C752')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " 'ACD2578695691483GB287FIC145CAB97E64889EF1D723476832IEA7234I6EHAD8A257936569C1H72D')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '967HE3A245BD71689CC81D92E76B7ICD65816C19EH2D78D5217IF341HFIE732365472A8972I13H654')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '962G54A834GH3215F95318F97B42D8317EI6697B45A8331E69H47B8CI67A42EG1485B93FB56ID3A87')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '9231654GHAFE748239784B3I156EC2G49816896513DBG471F2H3952843IA65797A652C8DEF38D79A2')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '248C5GF197I12D65C836E19H72D7C45I61HBI52AH36748A64725C9871D2E9F342936G81EF53981B47')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 23,".
    " '138EI6274526473HI1D9G821536D6B81935G759FC2148A83754B6I7H1943F2536E28G91DI426AE3G8')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " 'CI67E2AH4475A98C261HB4C65I7531D2G8698F49312E727I86E31D2G3IAE6485HI64371BF41G28953')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '8794156CBEC29F71H4F41H237599FD7H125332564I87A1785C24I6A47396EB8296GEHD1338E21D96G')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '659B14738G1H96C452243785IFA9258DG3FACD16I582767H132E941734H25IFE8F179B344B9CE6817')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '6C58479AB1I42E67H32G8AI3465E26183G9494H57263A317IDF85B36A4GH259D25C6981778I521F3D')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " 'G2684I5CAEI3B17684D81E36B794EH1726931369D8GB57923F58A4BFGI8531435I47AH6214862C95G')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " 'G68E39D21CD52719F8912H46C7589B37415FEC4186G29167EBI4839H5FD321761B89G4537CD2E16IH')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " 'C95G2AD8612F98453GH74356I12H3B6149576A9758CD254G2CI6H11782D95F3263HGED914IE16C728')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 23,".
    " 'I38F5G14251DC82967267149HCE2AD3857967362491EH5986GA423EBC8794614I16BE8G378631DI52')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 31,".
    " 'D26C58G919A3G42HE6E8G196C249F52A38D7DCG5681B921847IFCE53I68B1746GA39D28E8DB751IF3')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " 'G3I46182E865C7B91D1D29E8CG6E46A78B93729EC61D8H13429G653A26H7I5469G453B8A58D29A637')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '3G94215F86257HC4AI8DA5692GCB9G615843164ICH257358427IAF7H4IEB13FE96371842132F84GI5')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '25931G6DH683B49E717DA8563B9794A86EB335H72491F162E9CD8G8F5432IG11CBHI74F59746AE238')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " 'G46C58I21IH27D15F35C19BF4G849G2F51H36CE41H297182793F5D6798345AB32DA5I876H1E267349')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " '36H42I751G24A85F93EA9763DB81G32H69D54EB9718C69HF345AGBE17834F923F82195DG2I46EG831')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " '7521FD3HIAI678342584C92E17F42CE7H6919682C15GDEAG6943829A623GH4E3DG85I612B58DF1739')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '9HD61G2352513I84F736752D81I8734BA5I692D68571C1E69G34H2C5BG68149H46A39E72G91B45F38')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '7B6A58934D3I6721588159DC2FG61258C4GIEH794F213394AG2658HIG361245364GBEH915214897CF')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 29,".
    " '378412IE6FID8571232AE9FC4878DG12C56936I4G5BHAA52H9F374285F34GI1936GAH5427DA5296C8')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " 'BCF541789194HCG256785296A3D9128E34FG5DC761982678I4B3E132D695A7HFGE318429819DBG56C')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 22,".
    " '47815IB6CA92638E74F35GB4189HA4627C95926315H4G357ID8216981GD65327E32814FI46B59C871')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '9587146CB3DF582917721F3I5841DG2695838C5A74BFI296H53A47H76C25491D53691GBH9A24G83F5')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " 'FBC1D879ED95C27HA678169E243479HAB53F1EB6437HI368957A2D264387IE157A96D238HC95A2476')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " 'D371285IFE16C49G28I82E67A436548AI3G29HB67345173125D8IF7859F1B4C1FD2358973294GH615')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " 'E7H32F941932DEA678146879C5BGID21568C315GH62I46284I37AEAE9832D6786G149E2C2345FG98A')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " 'C84765B9196E3214781274HI6355289D76A3F94ACBH57G13H56I4213I45B8GF5D67H92A3B783FA59D')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '45F31I87298A4725FC72C568D9AB35A849671986EGBC46D7239AHE7D85216I3316H49G25I52CG6H14')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '427AHI3566I8532DG15C174F9H2HA2674E9375981C24F463B5IA7823E948G61A673B5IH4894F1G325')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " 'EH2DC7A96714F5I38B369B18E749286D17E3A73HI5D2645F72C89A3A5874B6I9D72F15C86H29C51D7')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '143BH6597I5F71483B782539FA4C5D728619167E4I3282I836ADGE96AH7B4C52G54936H18DC15692G')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '2718I63ED9C41G5628F85D32197435A62IH7B67HE9413IA83G45B6719528FDC58F34A79B243G6I851')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '6873E2AI45DCA892F79B14F78C596E41C27H471I2H35638B576A9DGCA829546F957AD832248653G1I')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " '6HB57319D3514IF28749G81256CIAE36G4286D35B87AI7B8AD93E6B59G31HD6H74965AC2F31B84975')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " 'F31B5HI47759D16H32D8BC97E611G98653B4C8492A56G2567D38A971C49F5826D52G81I3I2H13E674')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 23,".
    " '519DBCH67G4F1H53928236974A59H61C57D25G4B698C113B748E6I37465829AF2H913457951BG4C86')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '1I34857FBG65A293D8D82C67I1565G93H21428C451FIG1I47B6853571CDFH298CF91257424957H63A')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " 'BA64759384781396EB59C2HFD71CFG54982128576A39D914CBH657782A5D693I43H26E171FE7C9HDB')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 29,".
    " 'IA6537B8452H41F93G7D32HI65114C89267E8657D1CI2927C6ED187F9DE13B8A84273F5953B8IFAGD')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " 'I51837DF2G2CD615984H6BEI1376AH5792433E2146IHG794CB8561726CIE184HA5674239943812FGE')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " 'AEC24G98628G96CD5194681EB373F87B1594AB93D5FG87E4F98A2C635872D1I792EA4836DHA369572')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " 'D1BH95736FEI273481837164BEI2643GI5815981467CBCGA5H29D6128957FDC367HA4925DIE623G18')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " 'G1E43862I3I26571D8846A9BC57I47256C8AB85G13I64631DHI7B55931FD8GB47A82953F26HEG39A4')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '36D58I712H97B31E46E2A76DH932G86EC94165C41I782A49287C5FA25H97D369G43F51B86C84129G5')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '831F54B9G275HC91F4DI672183542F1HI37EE8A7D39263796E2AH47A35689D265B4IG31894821C56G')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " '91745CH6BDFE9823712381FG954BIH736E417162EDH9C5D38A97BF3841296G5EB9F47A38671C85DI2')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '57D891F3B13I2F745HHB65C49G11DH2E7369923846GA576E19C248485IB6G13FG2381E943A9D57F82')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '3ED82179FA69375BD8827I4F531EF84C29A79375H16BD2A46G93H5645A89B7381CG5249F792463AEH')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '692H4AE73C41E72F8I5G83962D11C97B84F545G91623H68BD5C71931G25D9868F41I3725925H67ACD')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '3217DH6E9D7IF51382685239A4GE34176I8B2A89457CF976H2C514863BAG495194563HBG7E24I8361')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '4H5732FA97IC6412H5261IE8374294EFH173857A32D6IFAC4I7825C26951H4GE7D328916189GDF53B')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '685397AD2231EHD796G4I21635891D75H2CF37264I15HF8E1B3497EFA8G94238B7DA39659345F2HG1')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 29,".
    " 'H17F459326I3BG15D8E2D3H96A75B81I6CG493785D1FBD6AB7389545A76C28IG2F489C1593H15B74F')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '5G92F1C48D2C9HG6516813547BI817DEF9CB3F51928G4I42837E16695723A8DB18E4973647CAFH295')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 29,".
    " '792HCAF541384562IGEDF297318AFE4239H7H736195DBI24GHE6C1BAI546378785321IFD463HG9152')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 22,".
    " 'D19537H6B38FD2A579G25I683411269H43G58E76A32I449C57B81F648751B9CG32I68145AE9234687')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '13H645G9BD59B78F316B73IA8459812G3EF452C16D98G76D58I2133294E6H1G8A57I2346D7FA3H952')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " 'G58BI61C426C4179HE4I1H53G26863I7B5415B1346HG99DG185C6B3196274HEFED1987322785CD6A9')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " 'DBGE819F38I3FB451751637942H715H36B4928674I3EAIDC1E268769235H1GD4GE162938831GIDBF5')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '87F42I3159B15F38GD345H17B969F7ACDB58CDE28761912856I4GC693541GH2AEB798436784FCB951')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " '25G9FH13461824359G3ID175826E83621D79I71C54H26FDBG89E137D2C158IF1FE4H97C29CH26G4E1')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '57D928AFC81236E947FIC1G4285485CIG612A39624E7876B5184CIGEF2398D14837E12IF921H46357')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " 'E2I46G18C7345A8962F1H23ID5G7529A83D6H91F4CB573D67B58I1F35H74B9148I12E3GFA7296358D')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 23,".
    " '679EH1432E2D96387A1C84725I6H43BA6795259C47F18G6A98532D16G9283ED4I21357H6853FDG219')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 30,".
    " '567H9AB3429CE4F71H48A27395FI13478FB58B4FE193GE67C92H143H27DI1E6A79C65D826D51B8GC9')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '456CHG2198B769AD35IA34258F76387I15B4EGDB6891C192E3467HA6E87394B742159CHF389BDF751')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '7641CE2I8B83976D15A59H42F7385B6DA9737C45I28F191F3874BE326D89E1715H62G34I7I45C12FH')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " 'H15G69D32I7D32H1562F31E49HG68197352DG45BH1FC9C9B5467181E7348BIF4F3592H178296GA435')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '831F24G5I5I68G14C22D79E38F15I32D61H776D91H25312H7CE49636B47891E189C25F47574F1IC82')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '8391F25D7E6DH37BI1A7B549638I51G843266DB31597H7HC2I6D1521C49E6787591HF423864327IEA')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 29,".
    " 'AEG892346286743I51394EAF278I68BAE4GC51B3GD8697D36891E27CD5BA6H96954CH1BG82A96G435')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 29,".
    " '683GBA459IE1H3427672D59681CAFB598347593GDB618478361IE2BC5I1F8GD46I387A2EAH7B456C9')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 29,".
    " '47B91E38FHC6G42A59159FCHD276235I18DG97826D31E54A8GC962A34B68G596H7EI34B12IE7A4386')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '3HAG49B5F249E86G31F75CB1I48AG59CB46896D15H3278327641EI514627HIC6I38A54G2B8G493516')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " 'FCG152948241HI36G5598746AC2H9D37E2A6A379625H426E81D9734B15F9783756318D2ICHIDB7651')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '7DA38I5B69F31E2784E826G41IC49HBC7F1563G51824IB15D69G38IFD172853321H95D768573469BA')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " 'B91D67CH54C75I82A6H56A32G4975I62C1DHH23AD9G654F15G82I3HA69G4E3295438B671C2761598D')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " 'AB3854I67785F29A3D9643GAHE271H39F5422F3DE18975497286ACDC5681279916C7BE4H28GD9E136')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '497HBC561EC149672882675AI3D284GAE639915683BD73FG49218517H3D29EFC6B15I874E49F782A3')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " '916B4GH53GC25869D1548A9CGB6429G3AF8517846E3BI6CE9H241G5I21F4378HAG253694364879BEA')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " 'G91485F2C43F79B51HE82C6A4I7154I7F23H6298D3AEGGC82159465D78A2369961374BHE8236EI174')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '3659BH4G18GD15F32921I473EFH854A92G36F91783ED2CB7645I816HI24751C2159C846773D156HIB')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " '271CH9D56F5I42A78CD83765BI1647E2CA9HCIB8145671E89G63427F49358A2238ADF9G551I82G63D')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " 'CB4195H67765382DAI819FD725325A78364I9471BF538C6H594A724789A2EC6B516G3H9493FD8E72A')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '25A6G9HC44F783219E3H95D1276123E679485HI31D2767648IBA3ED8B71F39EF53IB8G4191G453F2H')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 29,".
    " '761958CDB529ADC68743H27691E81FBG549329D8367AEGEC1I4H6258G63DABI4619GB3E8CB9581647')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " 'F3B7A54HI5H94B61C74178CI562128I76C5D36D81E97BG9E324186B6AEIC847758241F939DC6G82E1')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " 'A79F34E288F4925AGC25C1GH6943IB8657416184CG59BG459213HF28G95F41C356B4178ID19837E62')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '125934FGHC8I761425674EBH139E13B4978687F15CI4BI4286G35A45A8923FG697EC42A82H37A6495')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '1498326GEF58G1D2392GC59F1H4EIC42678A4618975BC8273EA649BF7354I181459HF37BI38712D65')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '45G38126I62C74985A9A82FE7439138B67D55H7134IF2D26E97CH1A72F98E34C9FDG52188541326GI')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '59184FGC2286E73A4I3D71I2586657CB49189246A8CEGH3A975264B7346E1HI4918CB765F5H719D23')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '7H5CB46A91639GE8B4D9B168E3716C84BE9G74953A68BH2E97F341471I38256C56217D9H2H9654GA3')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '158G2FDC9ID6135827372849AFE5HB3D1967673E89DA24I17BF538874293FAE2617EH394I5C614287')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '3I26E47A8568791B4C17D2HC956126D35H79I8G6A2435435H97FB158A96G24C3268ED1GI7DI312568')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " '5IGF3A482BA3584G96684I27C1EH73954BA6IFE3B18471428GF593368AB5749172439FEHDEI768B31')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '813594FGB275H6C419F4I271538DBH36I157731E4892F965G12DH323AGH6I456E4192CH78IG3E41B6')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '52F714C8I14I63H75B8GC95B6D1BIE16743H4F39852G17182CD569FG1843952H94527C1F325AI6487')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '197235HFDB5C46871964H19G253D73FHI52A1H65723ID9B53A48G63E8GAF942IDA825637762D39E81')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '69B4857ACC48917B56A75F23498139BF85477624358IAHED917236351I76HB46HI52D17C7D23HA569')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " '48I76123EGEFB381I413B59D67H3B45968A791GDHC562H56G21I43A53IG8F426BI341875487BF53A9')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " 'E64I71H32938625GD1AB7HD365912G49365HDEF8172I3398BFE4713D62897A55HI174C6B712E3F98D')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '8C96AG4257E6C249HA14B85I73FE641983GBA7B563849C98D27615743B51I8FB9HF3G4155FA984273')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '895D1F32G26C85G49AD7A932H65278ED9631F45132GH9AIC687254754182IFCIB8376514316ED9728')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " 'FE41729C83728I546A819C64E27386DAG52IE47289F13B9A65347HH4A763295726958ACD9C51DB7H6')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " 'EF9487213318652GID724CA98659517BD8C683G96542AFDB13H597375FIHA42149273EH6B8F451I73')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '79HB5614C261D3HG95CD5917F824C58G16B9F8I32D51772A56I43HI62387EA41E39428G6874AEF293')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " 'D1682EG39E8293GA4679C1FD582683AG295421I45H7FCD57639B182IH3415F76718253I43459GF8B1')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '217493F8E3E9BFH471H6DE173291G9C548B6H25I1FG346432G81I5768531I425DB69G18393AD8B756')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " 'G6HB514392149F37E85C98G4AF23825169D7649C7B58AG5AD9H326694H7E12CH37A26D95B1E943F87')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " 'H9F23AG5DD51678C2I273EI4816FA7D2E98329C8AG546485369GB1162578CD9735IFD182I4H13B657')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '2781C6EDI3E9BD78F14AF958273F913847E2723AIE684H45627C91I2C86E41757641B93H18DG3I5FB')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '5HD9172637964CB15H1C2658IG4H963D17EB5DA27I86C32786E49AA38429F7EF27315I84549GH6213')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '4I82735F171B59F83D65341H27IH54A3G92F261945CG8CI78621D534E689G1BFH91274E3G21ECD986')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '926AC48751H37596DBEDG82693135G61H492894237EFAFA24E9C78EHA2FI743C76415I2H294G8C165')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " '841732EFIG92465813365AIH427C94F5G2A86BH1C95D7751HD2F394GE92618C98637A25D21CE8DI7F')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " 'I6A7548233541BH69GGH2369DE14G53H9612I86215D7321C6748I5ECF298147H497315FBA27ED6938')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 30,".
    " '5A64937H27I38F21D5B48GEAF398F5C2GI4192A68D53G4G39AE8B6F74B3I158CE8416B79192587CFD')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '6E4123GI8CH1759D2627IH4F51CE4F279C8181C6D597B792A3H46583E9AG4621F42385I79B76E4381')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " 'F42198E7381CE6G942IG54C21F84H52C79AFG36AH9DB5B91546G8382A35476IF74B9H35135I61782D')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " 'HC61245I7451987BC6G29FE3184418279FE356234H71I9CG56A2D896E34B7HA874AI5FB3C12876495')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '15426G98C7I35H14266284C9AGED29375H1F31E86B97D8FG9D125C5IH7D16C2F47238A5I312E96784')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '52146HI3G378AI5B46DIF3B7158FDI813G527534B96H1281G659DC3742961HE56281G93DHAI5C4672')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '8I73B1465AC48567I262EI7D3HABA3E8F97464E97132HG984C2A56F4I13275H283E6GD195178D92F3')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '816CGE924BD59863173G91D2HEF632GHI541DIA5637285874219FC2EC498167174F3BH59698G15B3D')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '468B57I1CG9E316824231H4I57F39A5427H6B58IFG143764183IE2HG91356B44C1FGB589625498CA7')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '1D6892C5G9EC76A2488B74E3961E71BF89343861I4EG2BD9G35F18G2I68541C615DC98B738D1725IF')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " '65C928ADGI7DA63852821GE49C6H753A92FD6C94B851G14BF7539H43F592G8AB9A78634E587D1C269')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '8392561DGFEB7149381749HC652F824915GCA73BHE469E4I3678217143B8I6E89F5DA327BCE79641H')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " 'FI74831E2253GA64988419B5CFG3298GA546687E24ACIE1D639782765IC4218CDA872I6529815FDG3')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '2D1795FH3893AFBG54EG6834A92E7I8263A461834G92E4239A57FH1389524FG576DC12H9B4I687351')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " 'B3H75649A1648IC72557921DHCF1679BD5833E26H14GIDIH357162HAI645372237918ED6645GBC981')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " 'H63EDG21949721H5FC2AE3694787564H13I2ID2635G81183G92F5D634A2E9781598743BFHBGI36541')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '125467IC89431HE267FGH2935142H35946G15A47CF8299FG8B1D3E85934B71FCG2651D98A467H9C52')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 29,".
    " '253984AGF8D17B6359FIG15C42HHIG531642465972A8C3128DF579C184FI7BE2ID5CG618765B81IC4')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '168395BD7452HFG139IGC1248655826GD9A3IA628C745437591FHBHBI4567315G1328FID3D6GA9258')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 31,".
    " 'F7E3HA29441B67I85C3H94B51FGD62853GA9E91726C84738IA4B5FIDH1B75C61359F82D767BE4C89A')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 32,".
    " 'G34F58291A2HI7456C6I5C124G816B87C94E4C5FI17827H9B54A6C5H73B9DA6B46H17C5IICA54F82G')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '46253987ACA54HG6B978I16B53DG2C984F15846E3A7929152768D31EH3I72D6B63154I78497F28CE1')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '156H74I2CC9D52F1GH872IA36E46987D23A5DEC98126772153F4IH5CG269481642HAE739189347BF5')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '513IF24G8649718EBCHBG43561I637AED289HIB3761545412987FC846321GIE93GDH5261AEB976384')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '96GC2A8D5HE146972342CH7EI1F713F98D5BE462CG9182985D13F72845C61G96751IB38DACI784652')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " 'F1H5G9423I5C6BD187427318IFE1C6954BH72G58CF419HI41G2653CIA765842742398EF1586B4A739')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " '31I27F8ED85B41367ID6G985B13943A82E67728C65A9D1EF74I3287CE4I86B12DF5C19H78I16G25C4')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 29,".
    " '34GH9B16EBAF357498985D16B3G213F7HI548FD52917CE79C4AH6B4B17C65896359H2GDA7IH154623')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '765I3A48BD21758936398BF4A75216HD93E734517BF8IIHG6E342A623AG8594E17294HF3HDI536712')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 29,".
    " '3ID1FB87521H47E93F5769H3DBAB46G58913G536I18428A92347FED8G6215CICF9E841B7A52C9G648')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '6I57B14C8CABF8475I7483E92F1I12H74E635G3AB6D98F8D593A7225914F38G861937BD54CG82E916')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '574H29C1F3A87F5294F9BA347587819326DEE4B681I373695DG2H1AIC2674E8476H5I1238254139GF')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 29,".
    " '9638472EA215I6CH74DHG152963C95AG4F284H23E61I77A68B9CD573FE194HB5DA728639B98FCD571')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 32,".
    " 'G8A5C926DB95H6DA734F31B79E8AI8C42F753276E9DH1E468GA23I9E68BC41771B94F53HCH4G15F92')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 29,".
    " '3BE67149H681CI4E27497258CFAA39G62H54256DCH71IG8DE196325839D72AFIGB16E843146HBC975')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '647C2EA98H1B79634E53I48176B5A4HFB9736C95G1B842G89436A5DC9BH6751127453IF8H56A97324')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '579A2DF83213F98E4GD6H5732194I72A8CF582A36E47I35694G8B1851946G3B7CD1H2956FI27C5184')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '95G1H64C23HD9GB5161B6ED3879241FGEC98697438BE135H29A46GE1D723869763H49AB5I82F15734')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '791FBE83453248I1GFD6H731952218I5GD6394E613HBGC7F284A955H21D93767I1C68B546435B78AI')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '846C79A25EG24F198319382E76D612937EHDHCI645127547B8A9364IH7E32F1G1F294C5HC526A84G9')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '9813752F4GBD869135536DABI8G427193FEHC9A658472865GBD193HAB7495365462139HG379FE8241')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " 'G26C85DI1D58I17C2F91324F8755G42A39F889C76514BA62DH9E3G63B847A5I5H12396G47946EAC28')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '69273HE1D4GAE26398853DI1B67351HGID262476358AI98F1427C52471F59H39F3GH41E2EA832967D')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " '845397FAB136EDB798GI2186453G39E8126428467CI5AF1EB4I37817H9BCDE6CF9415H275248F7IC1')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '9248FE371AH7423695F35791DHB5DF28371I918GE42363279A68EDFC8A9745257AH4B36I2495631GH')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " '635B74I1HAI2386475487E1IB3F3897D25F162G51H94CA54693G28AEG4IC82F8C42F17E99F28G53D1')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '51H47F9322398156GD476ICB158291FE7384EDC1987F28F73245IA865ABCG49I21457C86G43689BAE')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 29,".
    " '9C58164GBFD127539827HCDI6E1367EH92D115I46B83GHBD713I65FBC1587949147B3EH6587DIF132')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " '6487CE219IAG86B534235941FGH394H7A5621286D5GICGEFC921849EF1B748C381DEI2764278635AI')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " 'B674198531E97HC42F348625A9G6C8GI5A425746129CHB1I83D75652FI8A37DH913D7B6E4G35F29H1')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 29,".
    " 'ACF5974B8572D3H19648IB16EG3FAIG823548439F5BA77253DA6982FC84E971781CBI65D954167HCB')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '524A7F3981CH59B46G697834B1EB5A469G833H6B71I54749C5H1269DG8C26156AC7D5829582IF14G3')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " 'H92736AD5D7F521C89315HI4726978E2CFA42436AH79EEF1947B3845G26138I96BHC71541H34596GB')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '49C216G5HG68D3E291E2A978C64E27364A898D95176B3136HIB45G9G28356D1384A7F9526A5249GHC')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '3948BA6757A56342HI2FH79514CBH9D5C716D56178I23C17F29E84942ACG568EF78D23918319564GB')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " 'EGC289416921G4F853684C51B7IH47635I2A592AHD6371FC7928453ID7F21582684A5CG95AG93H42F')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " 'A78E46I32F23I71H544IE8CB6718F34E97B15D97A2386A27C8F95429568G31D46H1CE29G7ACB49568')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '92671EHCD8AE23D769743I682152516IH473FDC127598897354FBAA82ED7369C56I824714G91365HB')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '13E769824B69HCD157784B15I36578B91CDF392F4E7186DA3785B9953DH26A74215G69HC8FG1I3452')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " 'F1E9482739472A35H6823EFG4A91867E4CIBG2D369851935AHB674DCG569821F98172D3E251C4H796')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " 'CF8492715291H7E63D5746139HB1BI64385G7F3E8I4A2458G2AC9FIH157423634GAB6958265839ADG')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 29,".
    " '582GAC69D164H29C7E3GI645218421HGI356E9FB3174883745FAIBA38B45I676579H34A2I24G61EHC')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '856C7ID12129584CF7GD3A268599382F75DABE1943876674EAH932793FH512441H73B69E26E491C8G')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 30,".
    " '3FE82I1GD89DC7152F712F54IH3B16453IH7G4HA69B535C92G81466917385D24C59AB6H78BG4FE39A')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " 'C67A42H95459368G1BA82IG534673I58421F521F9G84CD6H23175I6B39E8471I75A342HFHA46B7593')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " 'H34EAI762E16GB39D8G2IH4635114HB5C69767E894B3A29C1FG5849B14G5386D873621EI6C59A8472')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " 'I41G83B658B65D19GC537F2I81D492817CE6A87FC52943E64I21G853I12D67H46B7EH31IG8A963B45')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '8172DF359B35H971469FD1352HG9H26G4AC53FD5A9728751CB849642HE6C79195A47B683673819EDB')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '76C82IA4E852DF1G93DAI375862586437B9A247E1I386AIC28F7546GD918352135624I7H9B8ECG641')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " 'EH6712943937854BAF124IFC785B39167H5D681CDE7924EG8923A64IA6283755F3DG9128B78E31FDI')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '59823D67AG4C61958B216EGH943H47316I25I35DBG86162A8594C74E37H21F9A983E6274GF21I43H5')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " 'CEA678294267I45831984132F5GH1I53742657C6BD19H2D68I13GEA43GF29857HB359416569418GBC')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " 'E98D16G327D32E98A6F21HC74593549H12F7I78F25431216GD359882EF4C17I39G18B56D16D97E38B')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '9357A48F22H1CF54G96GD92813E34627H15I91B5DF8CGHE73A94F2E87F91D23693724A58B4AE83796')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " 'E1B46I387864C57A9239G82AF4E2G3956HDA4H9BG16355A64C8279A38625G949DF71352H752IH4163')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '7H31546B96I5238D7A412GFI853C7B546H9A1EI8B3746684I7A32ED1E268I3798GC1D562B36597A4H')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " 'D68E13I27G92648C1515379BFD825F84I73AHGC2F1DE991D37E82F1H23G569493D12F5875674H9BC1')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 30,".
    " 'HE619BD732136DGEHID79C58F122HGIA53F4I5D736A2813F28459G5CI64872ADG23918F58617B59D3')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '93A28D76EEH2967314647AC58IB612C48E797IE12FHDC3HD7592614561B38I7278F59D31I1C478E26')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '475IAH6326AB743985938526G1DG5C164HBIB69CEH1744H12I76532915DG386DCF82159G87536IA4B')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 22,".
    " '1F72D598383B9175464953H6AG2426391EGHCI5678124718E2DF3973465IH1B2FI7H14E385124C967')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 30,".
    " '16E42G89CG98FAC524D23859FA73H96G25D1271CD586IE64198G3BI58714B3643F95BAHG27A3HF9D5')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " 'GI5813F423F29E48174H16G23E923H95D17659678A24C71DB6C8954B15HG369FG5D39A28938A26ED7')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '712CE84965697243HAHCDF192752FE13D879493H57BA618G96B45C623581I4G1DE9726387I8CD6521')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " 'D82761EICA6CEH9427G59D23681H25I4F31G6IA37H2543475A28IF6542CH1797AB946835938A7E2FD')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " '236D9G18EGIH5F14B345A32H76IE73HD9F21A46352H79982F17ED33549AB7F828G63E914196H74BC5')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '3FD79512851I82D76C8276AC4IE5CIB864G1247931FE8186GE49C2I47613H5B385DI2176BF1578349')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " 'I26384G158G1BE946CE341F7H291FC498257784CB5A96295716DH36GIH325D1512F4G93H34895A67B')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " '9F12CE78454B678IA37CH9A45F2517H9F3423F42E78IAHBI341657A7HD53629436729AHEB951HF473')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '871CDB9F54938652G1E6B71984C298613G54AC6E479824E7IB8136DCF12I58771I35H62D285674C9A')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '157I48C6234267E81IHF93A257D4HF5A9273A37B64958925783FD17CE69482A4B65H1GI3198B3G456')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '243GEA9HF15H49FC7BI76238145D95637128H67I215433B1EH4GF98793AB5F42AD6857C965C49781B')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '9481B5FCGC7B6841951563G9H42593DG68A2B4F81I753781235FID26475138I9C7DFH52AE1H92C467')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '127HC695D8EF49723A4I31257FH589BF1743GAD983562236574HAI6924183GEA45CG9628CH7FE2941')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '8A73DBIF5C45F97A82B968A537452C17IF8D7684B35191DI65H72C491G38B562369EA8G4EH7462931')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 29,".
    " 'IB5C47F184H72A6953C1695H7BD5837IB46AG69148E3B2415FC8798E91C62G4F7D82E39AA32D9GF85')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '16H92C75DB59D76A83743H1E62I3I58476AB6D2591GCH178CF2954536D81BG99273FE814DHA297536')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " 'BGD568391569A4C872381927FDE452713I8F398FEDB17GA6892534F49HC71B5731425I8FB5H16I473')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " 'BE641837I371592HDF894GFC152194EC2687G65184IBC3BH97F415725HDA9634CI657218F81239E4G')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 29,".
    " '1738964EB592DCG168DHF215C79FCE9142H77H9B536DA142HFG953729CF1548HAE97432663D528GIA')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " 'BE438I67183A26GI5D697ADEH32163EBGD985H26491G347I38125FGAB846935398725D1F564IAC728')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '9586DB1733FD9172H52G18534IF5A7HI4236D38652G91962A37E84G29C6148E843E2IAGF61E74H32I')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '92ACG65487E81943F236D25819GB678ED139H1I2364754C5971HB66HC7124IEI4G58C62A512FD9783')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 23,".
    " 'C1D5762895861924CG27IC4H165AEB693847674H15IB38934B76E14B87319FEGEA2693489365HD712')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '91H5FB73463498G2EAB57C419681IF8B34G5472A9586C5H34G61I2C47F59281E26318GD981I7B463E')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 30,".
    " 'H9245GF1346E39A72HC1GF28EI49G63B5AHDB43A879561H54F9732EDA76I2388C9512FG42768DC95A')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '631EHD279784912F5CBEI736418IFEC2841724759AC6H3H16G459BHI2A437564358G61B916G925HDC')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '768D9A3254C1G528IFIE28364711845C29GFEFC9172482976DH3A5HAGB53649324F79A8E56918D72C')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '59831GF2D1D26EH9G3F7C249H151HB7459C6G36B1958495DC8F72ADF9B51H7382536G49A1C74I8562')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " 'CH475619257293A8FD6192D83GEIB1HF75434H73I521653F42A98G41927863EG53F49A28HFB153794')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '468EBI73A95BA7364H3GA8642I52159G43H64CG8AF5B9986E23D17A57FD2893B84391G656CI75814B')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 31,".
    " '69A5CD28G532F78D197H49A236EGF83E2419B4A96G85C5931DH6B7H26A4EI733I57H61B4D71BCI85F')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '1DH235796932F7DE18576A98CB44136EB8G92IF48G3517859A36DBE87C61I24AB3H497F546I2EG831')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " 'ADG6958326523H1DI73987DB5A6319DG6BE8B4HI3E17FF75H214397219FC584863514GB9IED287163')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '35971H2F478A46B39E2FD9358A7E3G4916HBIA4F28573628E7C491A23846I758E92C7AD6G4615938B')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '356AH4279D9GF32H15128579FDC7IB5184FC564G2C189H31496B5G637HB59412D897A3E69AE36478B')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 23,".
    " 'AB6859347875DC6291934172HFE218634GI5764EB91833EI78A246I8A47C56264G952CAH523F18D97')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " 'C4H1952G667A38B94E59BG6D18C5839FG4A21I72548CF4263A89E7H5I63DG21G23E18D69641B79H35')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '246HCI571139576D8BEHG214936D62G1C958791825CF4HE3D6972132718DFIE9AH65G2436453IB1G8')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " '58I2C7F4A7B68D1359DA3E96782G2C9158F4I18F74ECB65423H17I45237HAIF19C46E2878F79B13D5')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '5F84A3792BA98G53F443729F15H14G68E32I9EH73B1466B39A48G5B74I51H36F93D8GE21E81362G4I')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " 'I8725C6ADB13F489756E49A7C82HFA4357927E41928C6293G6HA45149EB637H52G38A46IH3F4795B1')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " 'F23G415988I423567A571698DCB2654371H9CHI15674B1478BI36E9EF31D87BD17928E6C283G569A4')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '98A56GBC46E74B319842C19H576456H93A7BH3IG12546G12F54389315F4H72998D27536ABFG9C18D5')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '61H97B35DD92351G6873546HI1B5214C78F96H7BA95C43DI5862G1746A85B93HBE973146193624HEG')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " 'D63IE1H2G9BG86C541H15D72I636HB37451I4952AF3G81C75896B4BC51D6798F89752A3D74A39H25F')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '346A9B87E9H25G3146G5AD86C299516CH427B3D71986E8F75421I3BH4G19E6339GF58D2161E23D97H')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " 'I4C57F82AFA78234E982519DC67638DE2197G45961CH29AB783456CA52697H427H13D59F649EG8231')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " 'EH4BI1763129637DH53F78E4192F7E13894B91BE6D87CD83BG96158294AG356GD1356B9853F92H74A')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '16H5293GD3G28F4I519E47C18B6817436IE2BCF598417495AG2683F85B43G917DCA8I62521I56734H')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '279C5A64H14F97853283E26D19G816D92G352IE7A38647435869A29H41F7EB3C57D2IF81FB1C58D79')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '83D59B61G1B5GF3894F97H41C25AH9745C26632I18E475GDBC61892E34619G847FB8I35A91H75346B')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '3E91287D64H75FC1I21F24IGC5869G23A485821645C7IEDC879216I14H62E73738I5DB16F2E73198D')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " '73HE4F91BB958C1FD716D79BC581548B36I7CGH916524F29E47H31269D85C711H376I45BDG52A39H6')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " 'D8AC76295752A94FH3I63B8E17DFEH14793B4392685GA7215CI6D882C7695149163D5HBG457HAB396')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " 'C17269HED2548CG96AFHI4152737851BF493629743AH5CDA958762572IDH6314983165GBACF52G894')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '65748A23I382E9GA641DI2F38E79D83G6E127A59B86DCC26E147IHGF3895124259471HCF4816CB975')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '26AD9C785CED18726I9782F54A38E93261G4F13D75I28724HI1C56IC2E1H6475467CB89A18G64I53B')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " 'BC1768D95768EI42135D92138F7EB9FA387468GI42CE1A34G8592638G95214F429A3FH7E65A47H39B')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " '64A75C82I239H16D75HG5D92A63A82975DC6F5G34B981934FAH527394EF82171BH7I35F475F241CHI')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '73E182D691F4IC7825IB8F45A7364G9582ACE12346GI8389BA74568I1EBF3G425C47968A76DH31592')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '639H57D122G5149C688DAB637E99287451FC436IBA857EAG3864922G15IF38459D78C6ABF3H124975')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 29,".
    " '591G48CBF26G9A38D548C65B97A189674BECEGF3214H9234H95A674AEHF793279813BF5D3BF5D9718')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " 'A23659D8G8I4GA23656G54831B984ACFB9752CI5H764A7569AD23H5182C67I49BFD78153C47E91H62')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '8IE1624CG1467H35B9CG2E49F813D8BEI716F7A4382959B5716DC8973FBA584862C54I1G15D89G263')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '415682G9C836DI7251IB7A53486B4A967538579C4H61B3F85127D91B43E6HG9GF39841B589E27A63D')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " '369H45A728B17F95C4GDE1C268I91D23G58F38E416B9G2G6IEH3146I87214E3A43658I7B527D9CH61')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " 'F3E94817B194BGC586287156CDID27389EFAI5H6214C7613EGD9282537968AD74IH1E362HFA4C2795')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '648E2A79C51G9834BFIB34678514H2CFI1576391758DB17E24H639834I7F215G61258C9DEI2314G86')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '2A8EI6437C7F428E19495713HF268DC25971237981FDE95AF4G238HE2143G691647IB853379586ABD')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '9FD53B17HGBEI183F4831F47B5I7A98436B54521IF873C6H5729AD287D96C516315HG2D94IE123786')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '6318DIB75H5G2361492945A73F8358A26G94671I84C2EIDB73E681D1C96G5827I25A84F3856D23A7I')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '6I3EA7824DH56C21G9G21H49F53986DE1C72B57963H143A42785I674526H1CI39F54A72818B93G46E')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '68E19D3274CI2E78F117B83F45I2G14CI5F8398E26G146D57H1923GA3942856645A8C97BB98E67C1D')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '15C69B784728413FE94F95GH123H39D21E6754GC8619BF127I5C843A82GF94596583DB712DG9EA836')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 29,".
    " 'G58314B964I17F2853362I5HD175DC9726H1A29638E7DH7FADEBC982EA6I43GC1G24E9866947835BA')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " 'B5F198C74841E3GI627C96D28A582E61I43GC9F7H4125471E23I865D37819F2618BEI4732IG364A5H')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '5H49A6B3729743E86A1FC72H59D84915C76B7B3FD9518FE187234IC21D78F95I76CE21844859A6B37')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '5841GI263GFAC825949235D6GAHCDH916752256847ACI1973EB864DC76B5891615IGH423289431FGE')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 29,".
    " '3DB85FI7A1H73496B5956A2G34HG38A6ED2925F97DH1CD19B83F755I46A72H3762D38E918C15I27F4')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '792D6A8354HC7B51F915F938G4B1845BF37I23G94H65AE69371B8D658B13ID7C92H745164A76I5823')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '61472CHEI7E91H42C6B3H95F417387495BF192E6GA3486DA3827955G81C6I42D63E92H17129HG4E63')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " 'C68E27I1D2D5198FC719734F58B78F29E43AC5I8147264216G39E8H536G91D2I6B48A573G14B35H69')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " 'DC6IH1572257463A899H17BE4F3HA374526992D8A6G3E657BCI81419835DF2GE726IH3D1C4F172598')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '6E9DH123748G2E391FA23697D8589F314E7BC7AE928645428GF3191B5G6C9486D91B87C573H9542FA')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '527643AHI168GBI5349CD185276756398D1BCI245A687H41F2G3599F523D8G1873IAE24FDAB7685I3')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " 'D27835FA93I51768D2618BI4735GF42H395128A954G6C95C17F48254H17B396619D38E2GCB7E69H41')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 30,".
    " '1BD93F857EI381G64B687DEBA3I362571DHID78C29156I1E84F273B93GAEF487H19F42C55F43B8791')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " 'G23861E9456AIDB783I84C75B1645I13F2782G68I5CA48317D26593DG9156H2129FC84575FH42G19C')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " 'EHG1I234F632HE49A79147365B8765B3DH1932859A47FDI168G3524589GA623A63B45GH927I8F31DE')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '57IBHC4168B34169G5D16I7E328C97AF4825A5H2397646428571CI741938FEB692EDG3815HC2F1794')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " 'GB6934E8158IF7A42334A25869G31ID6B8752F8715IC44G59H31B66E7298AD3142C5F897H39714E62')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " '691342HGEBCH5F71494578IA3627CI1F8254654GB389A2A8945GCFD175HC926386912DGEEB967D183')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '78EC9A426I4AB7F538362485GI16C28E71D91H54B93FG94G13F52HB13568I74H5DG93612679BA48E3')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " '243897EFAAIF25437878E16C29DA3D958F72IH2763E41657DBA839C154B978662G81E439I483GFEAB')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 23,".
    " '51926C47HF4C58G129728D19E36AD68I2735275C14H9F8I36G5241I84FE7321761I324E835B18D96G')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " 'I54C2H617FH17E4CB92G3IF18545862GA439ICB548176417396EHB14279E8FCH9G46321563E1BH749')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '842637E1I73A5D9628E9FA82C74CF8D21I7E174IH53F22E96378D17HF294153413H56BI7925G1C468')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '9FA3G824538EA4B967274965CH1DA7639E82529G184C66384EB1I715D8967BC673BEA89DH2I743516')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '2586GA4CI1F95D38B73G42I85F1915C26G84436G18IEBH27D59A36AI38DB567274695C8A68E713942')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '7F12943EHH3D5169279528CG461D16I73H2575C4H26IAB9861E3745471HI632B69345A78AH3726ED9')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 29,".
    " '7F18I54238943G26A5BEC61487ICEF98B14GI47E31B861B8GD63I5619B78E3475346IA2HDHBE31967')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '496G8CE217EA49B63H8B31F57D996H17B3452G59D31H6431E8FI7B21IFC78E4867E14C2935D298617')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " 'D3A8256977856AI34269B347H1EB5691C784HIGB64E311347E82FI3F91G85DB4BHI53176571426I8C')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '56A739D2H72D68E91C93H41B675CADF72985H62459A37E97C812462438E61I757H3I12DF1F97B48E3')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '796H52AC435B14F789H4137I52F5F7IH1243H31F24E97B94G536A8318D7I62E4G52639A896BAH5DC7')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '835B49F716247A5CH9IGA6382451685237IDB4G96A853E93GH41B69E73HF412DC617259881245ICFG')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '965HD3G128G2I156CDA4C76289E1BF3I4578489E27A63357FA8DB92896314EG7DF25H391E31I7D286')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '341BI8756H72536ADI9E6D713H2963125HGD784FIC251B1574869368241I5CG9A73B546H534H6G12I')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '1H47295F359FH3147B2376ED18I49E83B67A687AEIBD3C2174689E257I16C489AH3247F5DF35789A2')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " '2IE76A84346H5931BG73AB8D596IAG52D63863D87A9EB8B53F94A7C76A82DE9215G49C86I48F53172')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " 'C91HEF2G48BE47163974639BH5A98G4351FB3167IB5D8E2D618973ED9618723AH3257IF4267DC9185')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " 'I76C18B54B4A69573858327D19F68E42A793179HFC5B4342957HF11F95428C74523HGI167CH6A94B5')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '7538AF9DB1H49C25F72I65473H1297A65CH4D18C29G56FE3D78A2947153862IF9E27A84383296D71E')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '8672A3E94BCD569871915G8DB3F9751CH64BDA27569HC8F34291EG4HI7513B662E39814G371FDB598')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 30,".
    " '7D23E61H958C9BAG4F16I47825C21G86C495CE8D9B6179D65A73H2I34EB8F7AHF51G9234G21F34H95')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '12468C5IGH7649E23193E17B86D8F53194GB72C6DH159419E27F83I58736B4A3F29AD5877D12583I6')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '6IB71583D53H96412GA47HC2695E71BH3ID6683D59B71IB47163E84691EG3288A2CD67I5E7C28946A')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '283AE6947AG6I48C25549237HF1G3B86951D8914EC267D56A72IH34BH671395639582GAD715CID628')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '8219FC75DGI4285136635D17HBI392E16478FDG928513158743IFB6D9135BH785B4GIC6A3GA28659D')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '48I523F1GB1E796834673HAD592G9H35416B3E2F8A947A46927CH5BC69758D11G9DF85234582317FI')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " 'E2D91GC686G83D25A9391EFH4727I6DE18C2B35H97461A84623G5IAGE28364998415F72CB369D7HA5')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '6849B57A3G5I43A62H2C168G9D5H71D92E36E96C1G284C24HE6G1925I14736H1G38F29D546HE9317B')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '396EDB781AGE6984238241C7I5FFC9427815G84IEA236512683GDIBGD9E8163819CF2547365471BIH')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " 'I2C184765756392DAH418G5F329DA83G92E69F328514G57BFDA893837591FDBEB1634879I642HG135')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " 'F52IH71349A8643BGE4G32156H9516GB9348H2D361597937548ABF8FC49A275152786D3I79DC5B861')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " '4537628AIGAB94836EI86E31D7B597CBAF84DH16972536238457AI9D81C5BG6ABF87I5343572FD198')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " 'G15H36D2946I1GB8C5C8B54967A1EC94H26G62G351IDH8I42F71355IB374681783EA6294D16928G5C')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '942H51G368756C9AD2FA3B479854AH52G36I32G96D51HE6I83147B175284FI3B86G93D51C94AEF728')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '7E23689AD9AD5276C8H63I14725F71485B9334B179H6E5896CB14G5D91CG826B8AD567933762I84EA')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " '287IFA345A9E4B3H6763D58719B526DG319HCGA589B468492F17E375D632HAI918GED632C26I18D75')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 29,".
    " 'FEI284GA3H32157I461G49FC58237H54BIFA2IA7F3485D56H193271358BG4I667D319E2HBIH645731')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '2D3FH57917HF9A23DEI1E34768291456G83B827431EFIECF8B9471D29AE8376A53674B9876829C1ED')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " '63EB1G498DIH65327172149HFEC746IHBA53A82537IDF9CE164872521C74HF9G6482931E38I51FB47')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " 'B49E7631835741H26I6H1B39GD54FC7851929816B3GD5527AID8636BA95G8C4E94832AG637HD1F952')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '26H74531IE34129G68719CFH2451849CG5B695324F87AFBG581I34D92H73F513H76A54I215F4IB8G3')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '236871DI5H9GEF43121E49B38G6A84967CEB6351BH479G92D356815187DI6B39DC25678126731H54I')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " 'D8692CA753E71F84IB29145G38F3F42A87E9819E7D2367B5639HA4H9B541637641G2C985E73968ADB')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '256H3IA7D81456G923I7C2145865934186BGF71B3E489H42G69A357D59F13H2CI87D21E66B13E84I7')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 29,".
    " 'IEA64B38746H7EC1I2237819EFD1B6DI857CH37B15F49D9E376A2HBCI7158645869243GA741FH3952')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 29,".
    " '4761C89EB9C8D2E6AGB5A679384324G69H15591B8DG63HF7E13D9224G59A68C8EI3461GB1C67BH945')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 29,".
    " '349H15F728A76B35ID6BE97D1832E4G6HI3A98FA3E472G31B49H564B71H3EI6C61259G485I84F73A2')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '3G51426H9DA87692C5629EHC147893E26D17FB41978537158CD9F273D25H96AI8F37AE4BB5AD96378')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " 'ACB4768596I75283AD84E1CI267341IFG528H721534695I6428CGA7H46IC21593E2817DFF1B754983')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '76I14B3HEA45938G6B8CB75F4916I34285G12A7EIC68DE84F17329H14B37956326DEI8719G51682DC')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '71E24C96HFCB8GI4514H95F17B31EB894376347526I1H698A3G245D37529F8128E16CG94916H74C5B')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " 'I68751DCB4329FH7155G134286I8ACE46297649AB7853B57938F1D125374FH9CID28657A786AIE4B3')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " 'FE8G349213GA89B5D6942165GCH2851964GC963DHG1B5D7A52389F3495AB867FE8734219217689CED')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '273E86D195A93D78B6FH4A2975C6573IA8B429C46817EHD12759369627451CHG34981F52518CFB4I7')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '985D26G1CC4A87E62976B39A54H3IA85B674B87D96153654AG32H926IECG148GC89145F2D15826I37')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '427H9E16CCHI1762451F5423GI89AB5G438FG38692EA4546CH1279631B5H749IBG46C851854917FCB')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " 'GI68A524314327F9HE58B94C71FCBG56D981519837DFB8642I13E7438A79FEBGE1628394629D35A78')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '2I13784E63H74E6912465B19CG856482G1CIB93A65G487HA9D3652F8CG12I4557I83462A124E9F837')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '29C64E871DF791832558123GI4F9H2CA45671745HF2CI6E37B98A473615HDB9842GIC651A95462378')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " 'CD28A76I56I854BC1G7A56IC428B84I715631352869GD97F35D28A72F13H459D51769HBCH39E42167')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '31B59G86D9D8362E1G7F58A4293F58723A4912C4IF87594G15H63B9CE2G14867H16E4B3ID26C89571')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '37D21659H51HCI4267B9F78E34A683I25A474GE6C198B1B98G45F34E97F18C2G2C859A4F618D32I57')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '967H5D2318359124FGBDAC678591G63I24HE24C5861GI98E17D632748E1C629F2A798C545I34267AH')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " 'I5F42C81GC48I712567216H5C9D56D79813B8B91C4EFG1CGEF29482D53H167961379B48E87I456B1C')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '3HD92617E56B417CIH791EC846285769C41B92AG8D635FD32A5I87531G6HB492D61E987387I324A5F')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 23,".
    " '69H14G25C7B5I6341841328E9FGE81972D3637D15FH9B629C48G517B58A93F4631247EH98ID536172')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '2F18C49G5D375291HF9E86G13BD61H453G9B7452IH361B9C167485A27C49586653872IADH4I51F732')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " 'AB96578434763B891E358D1I72F23F9715HDA57F84B398I42CE1F7C68G92DA57I15DC862E42681973')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '2A98746E34CF15B89GH75396A24I85D61G326243G89A571C9E24F854619H3BG781B63E492CI54768A')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '34GI16BE8HAI52D36726E37H19486542A79CI3B7851467419CF5H2634189EG2B7A453698859F2GD13')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '34F85A72I79A6DB58C5H29374F1B63174E98H75I2F134AD9853B7F9C2DA76854F83E9217715628C9D')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 29,".
    " 'EFI824137187635IDB423AG9865456B8CG91CAI76DE28G82IE1FC43DE918672896BGC451217546CIH')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '89E37264A374AF5HI21B6948CG5G69D13528531628G4IB8DEI76131H49E72C6256D1C98G73I862D5A')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '5G38F29D18923D17EF6A45793H2497C16B852CE9H4617861B57I4372H65D13ID63A2I57819E7CH42F')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '674892EACI51CD726832H65149G7C6125DH9582DI3G169A48765C225A36H94G8341796BEG6IB4E1H3')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " 'F91C24587G83159FBDB54H671394C29G58A659A8FB43G67H34A92E7D316H25I9A6245CG85827I34A6')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '8B51C76I473694B5HA4I15863G257H94A36241362G8IEF29H53147B59G13D86A64B58C79G3H96D21E')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '638124EIG75IH6C4211BD95783671B8DC965645297CAH3IH615472B8IDE6371176932EHDE43G81B69')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '1GC548296624971EHC985F3B741DHA7653B9295348A6G367B1I85DH1D637I527C24E98165I61284GC')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " 'CH4G926519216D57C8765H13ID2HDE936127316B5G4892791845CF2FH47351IE74A9B863391658DBG')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " '6AH9425737E91FC4B8342G58AF9251DHG369684392EAGIGC615284A948B6G3E8CF975B4A5B74C1896')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " 'F8B13479EC54BG9H16179H6EC2DB513G84697D86925CAFIC4E1782HDFI17523923485A6G517B3F948')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " 'F72D1893E431695BGH58IGCB16D2ID85376A183GFB54I657491HBC1H73495B6326HEG914I452163G8')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '45CH2A9677896345B121F9758DC239E8471FH1G3FB49E5F41I73B83G21D86I5I4H256A73651G39D82')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " 'H3A657B4I5G42I186C6I23D87E11G39H5462928647CAE5FD21C87I718E2F394D3F18I752925437AH6')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '14C65I87BI8BGA453656G238D199872C45A6FB18E74933456I1GH2G95D6132836H27I14EA2DHE3976')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " 'ID26783E11859CB4767631452HI28453G19F5AC6I87249G642A3EH86941CGB5B4AH5G369E37F92814')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '8345GI6B11BE684G9CIF73214H54AC287965972DEF318856139B7DG983E6AD2261HDI53754C71B69H')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " 'G92346A8E1H62E93G4D53H71I2692CF7D51H56783A49BAH45926C7267DC9851I18625G43CDE71826I')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " 'A98572D3FE34FA9278BG6843A598EG24A963361I8G45B49263E71H7153B4FH98BC796AD59F45H1327')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " '5824F79CA7A39B56H44I68C1752176CDHB9583B56I14GE49B17F83G54H2I613291C5FD7836817DIBE')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '192EC8G6474H62I5CA35F17489B8DA37562II56B843172C79FA485953416BH7162HGC495GD8529613')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " 'F83IE2A74D2138796579564AH3B42153679H5GC8AI642I68D27E132D58A9CFG1IH7C62543G62E4189')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '346219HE7AI75F83D25B8G3D619D6A532798879614B3E352HIG461I25FHC174D8F721953173945BH6')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '76143E92H2CD86I15GEI81B7D36A87F93E4B4I57A26H326C85D97A2G68593A4948C71E263A5642GH9')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " '6G48C52912C17FI54H985D21F3G3B671I45HA8D32569757I8DFB1CA62E8CI47D5C9728167981F43EB')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '5148926CG7F85A39D29BC7F4158I5FBD8371234175HI681G39F245DBEA6378938942G65A671E89D32')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 23,".
    " '83I64E21745BC7196876192H3EDC81596GB4EIF724183B47A83F95IGH163452215H49FC74365G2819')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '436275HIA5928AD7F3HG1C69245CBGA49658651378D2I9846EB713962714EHC185B3F947DCG598126')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 29,".
    " '2G38AF9E4E81934B676I4G52A38C2A64I78589F75241C5DG8132F9DF2A38EIG3G56B91D898A47E32F')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 23,".
    " '4EB6897311895C76D2637D2A5HI578294AF3913G6H254BD61537983278DEI1649A37FH2EHF5912374')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '465C8A7928392571DFGB16I4835E13BD6H797HB3I54614FI17H25C1E49B86C7F2CE74I189873A65D2')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '4E67C21IH1CB6987E4987AD5623865B79CD1D2IC1587F3714F85IB5239146HGI6G28354A81D7EF239')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '567B4A39824I68375A31H759F2D87E6124CIDB6C95H17A93D8G562954AB6GH31G89C45622C6HG5941')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '8EF42G9133G2IH15469415637BH769A82E34D1H735629352F9DA8G375FD1298H9DB5C1672168794CE')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " 'BD579861C186534G2I937AFB4854861BI35G27564CH9ACAI578246I74H3A5623E89F24176217E4HIC')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " 'F1GH59234938DA27E6B45G361891IC5764B8F25H4AC794783IB65A36594BG8118G56C29D92D8A75F3')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '8541CB9672AI76534H376498AE2483GA65295IF8B3174721I45HFCF91CDHB75D32F5798158G2196CD')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '579DH63A2148I32GFECFB175984924HE7163FAC29458G85G63A4BI79823A645DEF879321213546GIH')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '78261C5IDI34H52F71EF1G94283B68375ID13A74985B694EFA2378HC64B7AE924I16E78C157H3I426')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " '4E13F92876385724IAB7IH14C5659D81C6GB18624G9EC7B3IF51D8A25G48I36H69C15GB443G69258A')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '2719534HF368GD1E92IED86B713328F14G9E1G58B94C6FDI375281167E4I8CB95C28761D428A36EI7')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " '65C41978BH9B576D1C71D32HF595382G1IF4BFA9847C5947E36AH23D5826AI7629AE73D88G14I32F5')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " 'I4257A68C85134F97B67389B51D4C61B5798298467EA31EGIC82D6314HFI2576B9735AH4G85421C69')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " 'B1H37496E53G6IA284946582ACG641E2G8939538467ABGBH391F547C24591HFD6517HC298AIBF3475')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 29,".
    " '2ID38E16G365B71IH4AHG49F523F42713HE9A5984F72CC7895BF144C8921EG65A26C74I8769HDE231')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " '6C82794AEB5G81496C491E3F2HG864I5G12C375D21FI89AB368754341GHF592789532AD6FBEA49H73')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " 'C4AE6G982E69B84371827391F5D23D8A5F7919H63G4525G6IDB13875312F4IH8B69D37A541IGHE263')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '2EI76H413463E21G8917HI4C652C91875FD285B6ID137764C21E891BF9375849782DE3A6435HA62I7')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '4EF7283A9721639H458395AD6B7B74895F311983GF25D36E241I7H9421675HC5FGIH341BA83D52G96')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " 'HC2IG165471I64E83B6458329A7D18C2E769I27168DE335F47I12HEH719C2463942G65H1261E84G93')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '358D7IB614I163B5H72F71583D9647HI312591C27E84FH2E614G9C5HF9147C2C24768A59971E3BD86')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '287A3I6546C547H9A2AD9B56CH73GB46HI1EE46G91B8391H52C6748B1GD659336G15I8244958327FA')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '374AHI265IEB3468716H12759CDECG8164921H9724FCE4625I38179D1F2H753E6G413B98CB8759AD6')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " 'B6483917EH15BDG639I37156H249D37526HA7EA4869B3682CIAD7E427CAH5961985623GD5FC749218')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 31,".
    " '71286I43E95DG2CA86F83A54279E7D198CB6FIA2C547883B46G91E657BDA9H384I36G51BCBA5I87D6')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " 'FIG24513835169H74B82D713IFE5HD7AF329AG3E298646923481EGD7CH62951216ICE487589471B3F')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '3547H9BA667I12458C128EF37941BCI6GH4EG58B41C969463H52A7FG8492E319A58C74F243B65A87I')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '3F92G148554B9687CA71H54C26I13B89765D6I7254AH3D85F31I72EA6G28I43379D15H268B43961E7')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '48216I35G65C2GD89179A5384BF6IDE387217B8416ECI1532G9684I73HA5B46A4B9F7385H65C42I17')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " 'D51H2I736378D56B1I692G1C54839824G1FE6B71H59C41ED3F98B79146GC582HFC592741275481I3F')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '5942F7813GAH94362E36B1859DG63A94E78B4598G21C67286C1DE9A76D5HC29B84C97E61E93B16HG4')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " 'I8A45263G325H67IDA6479C18528D9CB671517259843FEFC7142H95F42731987A96HD2E3328A9EDG6')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '7865B9ADC2EA483679493G16B58FG2H34I158DE1927C613I67E84B36A25849G524I17CF89H73FD521')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " 'D5F13G9287398BF4A5H21594G367D36I52816512849GCB8IA7C645H64E1B379AI234GE683E79F8DA2')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '6G43EA8B981CI26D5G92E48G31F53F4AH792172E69CD8HI4273561B45I871637HAF34295639A52GD8')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '7596B84C16B3GAD8594189EC2FG382E7D196AIG268D35F45139HG2I63247H1E542C8A976GHA596324')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '9H62C47E147C5168BIE12G9843634287I16EA6H2359D79756D18B3D93F2G518FE1384792B8G15IC6D')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " '846IC1E279728E41FC3AE67B49819B38D7655CH62G49A7DF159BHCFG82E9413319G46B8552DH31I67')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '3718D96B55I4B63GA8FH27153I4537I82A641HF34795224956A8GC45F79C21H8396214GEAB7D58936')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " 'G8E16924C162D7C859439528GAF517FI8432B385416I796D372HEAIB1876354785CAD92F643295AHG')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '2683IDA5G7AC5268944598G12F3F85G13D29C7IB45168A42I86E3787F9C25DA9EA4H763232D61E79H')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " 'D56I23G181734F82EI9BH7156C43691D587B742CH6E91HEA2793465H46C729162G91DH35A93582D6G')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " '8BCF7D5I146A98573BI7E12C68DGC5982146148CE6B79296D17E382F8DAGC59EA76I3824349852GF1')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " 'HD7E2136959634G28A13B96H54G673A9B4EHD12H35FG98I5674321BCF7859141549B3GF8789DA6B53')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '4659827CAHGC5164299213DG685673EI4BA8BD516893G1I87C24E635I8BF1476HA794CE2B74513H69')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 29,".
    " '64A583I7B35BFIG814H9G21D563AFG23E894935DFHB71428971CE6429316GEH7865DI123ACE78B649')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " 'G16DE2C89EC9687B4A42H91C56G56A2948CG47B3AH956H39F75A421759436BH824GFE1933I62817E4')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '367E892D1BH5G416I31I42F385791F72H45C53241986G74HF3E912HC2675A94A56IBD378D79381E26')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " 'AG29438564657819BC9C8BFE714F94CA572853827I61DAGB846E9328153G46I347H96A52FEI421C87')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " 'F25987A434C9BA57H6G1HF3459B35F71D29H14269H35GH7IB5CD614615CI8G2EB3874I619871263D5')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '1F3789D2587245A63IE49C26H71I7H5A4632126G93E8445368B91G3DA29GH562FHCD59A77951F82C4')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 23,".
    " '3GE291D8616254HC7I948GCF125732F54I18495831GB6FHA2794535B9847163684IAC257317562HID')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " 'B13H745695849C62AG9G61E2DC8GC51486I2H91362D75B64EIG38198A42G35672C65I14H64581C7BI')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '5IF2781437324AE8I6418C69E7B92E31GF8DF7CB4H159H41F9E237859GC2461CFA9845277241569H3')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '15G43I68B96857B13DC2D186G59398BFEG147264813EI5DA937862HD1523976B93F17H456754I82AC')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '91H23G54FF2548IG137CD65A2984B5CF17H93968725DAHA7I45C62852AI4F739CD2671581765H34BI')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " 'FGB5438198491627EC153IG84F2168254IC74IE3762AH237H9A546795D21CH6F81I37524CBDF85719')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " '18C74I56B79EA62HC4F42853719DA827693527I4EC61H36519H4BGH57C24F91I4F581327B3A9GF5HD')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " '785IF4A326DA3829E7392E714HF3EG6184B942HE79A3FA69B4CG58296HGC5417AD295863835614IBG')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " 'D72F93851A93E874625H6214IC7CB95F71H467124HI3ED58193G6224E93671HHAF75D3B937I82A64E')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 29,".
    " 'I7B165D83A84B39FE763EDHG19B7A63E42983DH97251F5B98A6743H3G64IE21495GBA8632613E8I7D')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " 'FE3719248842356AIG791BH463556G19B38D4CI6G8B15A28E439679254C6HG178DE2A9633AF8GI452')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '361I2G584E79384A6BD8B65193GAEH6927432468CG9157I31452F8BAIH75D36653D9A728874326E1I')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '3G8524AI6169GCH2452ED961783H3B41E769457F9B38AA96HC742E2DC68195G976EB481351837I6DB')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " 'H6C427519754I6A23H192538DFGIC4658AG25B71D9683FH1B73945GD13H5296C9241F87E85672I3AD')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '253784F1IAGH695234649ACB75834EH9F127I62741E8CHAG32596D9C14G85624573B68AI2H6EI1473')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '648597BAC123H4F597EGI23148648E9263GA9C1DG5B687F2CAH954HF273415975DF1I382193825FDG')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '482G65C199E3AB46G871F389E2417H95D23FD62C81G959C56GB1D85D1HI76238CI21F547267453H9A')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '7A93586BD42H67951C5CF2DA9878714FCB9E3I47E2861FB5H19473IH7132E46A46985B3G352GFD198')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " 'DACI76E8268514B39G72953H16D694257AC8E1HD36729B73HIA64582E74136I9F42538G13A7IH64E2')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '9371846E28F4EB37912A59F738472H561C4I95643G21HD31H9BG56B1FDG3895C79185FD254H62917C')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '9A5428GF3H7B6531496437AI85B23D68I157GA84C59B69F512G4CHH42391EG636G58D291E91B76C84')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '8AE3946B79C27AF8E46472851IC278DC9561E6IA284G3D3175FHBII52143G8F681BI73453GD568912')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '5736218ID89B7DE6314F18395B7D15B86G393GI5142F8682G9C15D1F73EH942I83427A56B4E916C7H')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '5436BH971GI83516B4621497EHCH5B36G19443718I2FE1692D57C8DC5G16289912843EG687FI5B314')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " '63A8EB947I5D61G23H872439FEA428CIE176AG5862493396714EBH213589G6DGHF341E29I45BF7A83')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '146I57H2C95H26C17D32G41H5I64H93F52G1CA7HB9546265A74I836AB59873448573AFI2739FD28E1')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " 'C24A6897561E9CGB487895B4AF353724F8AI4H67I13E291B35H64G6837IB4E1129E64H7CDG5831296')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '348529FG1A69HG3452E7BA649834978AE26C62E39D78AHC16274E9154G36I82BC69A85D77982DE31F')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " 'BAD3I5768985G26C4167C18D29ED83579A2F65B1CH4977A94B65388D1932F5G2F35G48A9I57H61342')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '86375I1D25DI218C6GB1GF43958491237EHFG238E64915861ID372C24F7E918A759826CDHFI43A725')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '7ED981326831EB6G949624G3HA5549F12H73A723486EIF38G5I2411382I74FE96G415B8C52D38F197')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " 'C2H671594791E43BF865D2HI7311E27HI4F3IC64128G5D78E63I12937846BAE154C2G6898BF195347')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " 'CE976184248G9526AC612DH397559D62317H8617IE324B3G84A59FIC7286D15ED6A39B78128GE4369')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '4723A86I5E1H29F374F39EG4A28HD1B59736I6C74AHBE75B38F49152D18396G6874EI132IA32678D5')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '8FD1C257I931E74F8BG52869D137BF41839E148CI526739E62714HI8A657B434B38AI7565G62349HA')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '6235G48IA489F13B571EG2H9463B86937DA55941FH372CGA524896G4B35I16H8367BA9DEI15F48732')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " 'D3B7851968592FA47C671C9DEH2F2D3578AI5971H63B481C24IG5F9G12F8E43FC8I45G124B51379F8')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " '651294CHG7CI51864B2D8G3F91546H5CIA7BA93B76D85EG24H16939168D5GB33EG921864H24C67A59')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " 'B57C14H96HI16G2E433648I572A42853I67A31976DBHEF5G1829439F21H37D51574BF938DC85792A6')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " '2G94651H38361IB74ED5A7CH29F65D91B8372H36GD951I17E83F42GI6C2AE48E18D69C273B48G5169')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " '498F52CGA673IA84B51BE473986A297C68DE5HG24IC61F34E1829G213587IFDHE4196732769CDB851')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '291DHF357D7E312986863G95BA4HA4E79623F231DH5IG9EG6C21487459CB168269851G3DCHA47F529')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '4H92C6571B1G594F3HFC5A78D92915G6B348H7FI4312524358A96GA53824F974897F1CEB726CE9814')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '792865DAC365GA48I214H93B765154B86C7I27F539481389DG15266379B15DHIE86D3AB72A48E76IC')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " '7D25CF981198427FE36C5HIA274675423H1I849EFAG32CAB78954FA6H29435G975386B1D42CAE7I68')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " 'C48E71629591CB68DG72F98435A2361H54IGDA8279F53597DF3H1285BI1C76DA34765IHB6G92D8135')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '71F34H952H59762DCA342IE1786B31487EFI576AIC248H9D2651378G4195FBC3BE68G914619D2C578')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '1E867B43I9BC58471F7F4913HE2H25I16C47AI73D2658C46578B9A5837FA294DG1239H6562I48513G')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '1C7469HE2E62781CI4I48B5376191537DF2H4GH9B61356C21H54G9B4F593G818596AG243317824E9F')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " 'EG9C2861468347A95B412F95H3G2439F71H58I51C42671G6528ID385B49F73AC19G28E4F76D3EA289')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " '275839AFDI31D26875864GA5239C5G62AI4814H59C76B692D78AE349CE16GHB2A73H46E958F9BG341')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '3GD9AF258BI5C871461F84257I3E42GHAF399G35FB4A8H16349E721654BC8978BD75963A93G68125D')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " 'C9DH6512G725IAC84FH61D27I535C92A67D8187594F3264B3GH195DE1FH297326H3794EA7C95A42H6')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " 'ID2631H57H36457A92157B8I4F337F12E48I98467C21E5A294H73F7942F35A85F87D13B9CB18956G4')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '51B7436HI967AHEB43C84296G51AFH9372544G95B6HC1523DA8679C25D7A896618392G5DI4G86513B')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '6GH9214C534978E2FA25136D87I2DI18C7561C6EI78B4G85F42A93E97314H62F12I78D534C85BF917')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 29,".
    " '351G69B8D47BH5CF916IH1D257319H47F5BC3265HI7A4D5GCB18698C56A794296GBD8135214935GHF')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " 'E6AG42I38347H95F12I8B631E7D8176932EDIFC254781425G1H3964261HI375AGI5364B88532D71F9')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '294815CGFF5H43719B317IB6485GC9428F5A2A496E7H36E8GC1249ADB587963E79C4F8218631925GD')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '5C28I716417F43598B849B61CEG679B58D132E36AD7I84AH97352692F38A745C41527H6I7856ID13B')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '384BA95766E13G89D22I74658A319G82C64E52376D81IF4HI51G32D58I317F2B36487A95179E2F38D')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 30,".
    " 'BI3G5F14H6HE9147B37413829EF932485FAGAEG39F24HD68B1G539369571HB4D7A8C2569H25F9DA73')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 23,".
    " '57C24I8166213E89GD4IH1F7325I28731D654135FB89GE76849B313946871EBA86B4573975BIAC684')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 23,".
    " '2953A4FG84HA796352763HBE491429761E8C615B38I74CGH549612I47132HE68235FG1491EF98D237')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " 'HF5974231419EC28G673B81F9DEDH31965272I7C8EA64651D27CH97D831I6EB92A65H7435F3BG4198')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " 'C91G58B4676D93BA8E82EF4A7394F71B39H58I35G62DA152DI83G661I83D572457F29C18BH3E17964')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '538126DG97AI4E36826D2IGH531613HE7294BIG164538D85329GA6941785CFBH75C2F94126C19D857')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '45781C6BI61H42IC5G293E67D18395268G4A8F17D35927B49EA836EH29C61G4A76284I3534I1756HB')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " 'DIEH317F236H2G59DA7A2I4683514628CE7I7596AD832BHC597461I57FA83241H3427E9662D3591GH')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " '5923AD87674A68BECI63H59G142FCE149G28427HE3196H197B6C5D261DEC98GIG5268314483I71BF5')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 30,".
    " '24E91F83G87A35B46I6CIG8D51B528C71D69F14295G38973D68ABE6E4AI37H21B35H79D68IGB463E1')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '8E7FI14B3B64C87I1E1C95D276894F3127HE1E86G94B3B73H5DI16579268A3DHDF5317923214IG685')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " '37486A5BI9FB7E438A51H92C47FD56982G13H27A36ED93I1GD5862BC76IH1456954132GHA84B57F39')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '4F98731E2C27DEAI6885A62I34GI86C21G457C5FD9812B1DE78I63B1G53469H593A8F2744H67921C5')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '768I1EBDC9CBG4658A14523H76I6H91EB374475693A2HC2A487I5FH97531D2635DBF78196A28945G3')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '18G4639E264I57B18353BAHI647CA47256982689C17ED97E8F43B1531H7IB46H27D16C95D9F253G18')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 30,".
    " '576392DA84AI7F85B383B1DEF9724E18I6CG8CA64G29E7F92534A89E4GB18FC182C56I74C76I84E21')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '398F5D27AGB13894654562A73I87459H31B69CB61785DFH1524I73D17832E6I2I3EG61D88FE14973B')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " 'G4BH65I135I83217F41F37D92E832D1785IF619B4EH37H75C96D124H16392E7I5C47B18F62G58A934')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '87C169BDE4295HC617EA6742893F34G8259AI7E3418F212H65I43G4263EH917AC879425F975B61CH4')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '58A64B97CB73958D61D6ICGAH254B78E93A639612G84EA5H634297238165G9DEA97C46H27DF98B513')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '1H4235GF9625IG83413I76D12H597A3D865B86B5197CD45CG2F819516H9C427D83257A9FI7B164538')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " '589FCD7213G2918456AD6527H3I84531BIG6BF7E8914391CF7D28519G26H4E362D73E8IA3E84I1GF2')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '41B75C68936I184B7E5H79F21D3H34I6AB75597823FD162A47E3981263D8EI793H7E641BG54BA9836')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " 'DF2H95173EA82734I6G39D1F2583189E4FB765GH321499B46G15H378624I53A92A385GFDC4E167H92')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " 'A65723DIH8C24IF15797D85136B91BH5FC477FH2435A94C57A96B86C12845GIIB4CG5681E87A96243')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '718543IFBC96G21458542HI6173FH1CG425957I18B63D32D659G8A1968254CGHD7913265B35DFG918')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " 'G98362A45316HDE2I754B791F8C65783A4BI1H9452763324IF78A5916EG4B83E3D928FGAB78136DE9')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 29,".
    " '96218E34GA8G324E96345I7F18BF53B19H744197F82C57B8DEC6I17I85C14B66E394BH7A2A4H6GE39')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " 'EI82764311264CI5H77435A89B68197BC6EDB54F98G1363G15428I3851F7IDB97A84B365DF2C95H71')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '298CG6D5A15642IC7H3DG1856295F2713IHDHCG2945F1491E6827384763E129FAC98274595BG14HCF')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '184GCF259CI651287472E498FA3E1B497H63D63185GB99H7CF25419G86413B565A23794H234HEI176')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " '89A24756CGE4C61I282C69H51D7GB4IC5186139D86EG2F5HG1B493DGH3126E9695847BAC321E69874')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '742HECF918139645GB5FI721438126389EGDCI5F47128HD7A52396D1H235967256789DCA9G3FA4285')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 23,".
    " '293F47E1815G28C69DH6451IG32861359DGB7B94F831545C27A9861C59B67H4842E71I366I73D81B5')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " '4G9853AB6C6H241EIG125IF7483E18642I374B97H36A57365IAB4H39D78A26E15FI32874872FE4CA9')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '7123849EFID3E26817865GI1234578FB1DI369A35478B3DB97H1E6BCE167849169DCH275487529FA3')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '417EHC926CFB9748159H5261D3G7EA268394D23A9G65889654CG1BH45FC21792317H95DFF791E43B8')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " '213657I4H89DCBA576GE6D98312ACI425876482IFG1355678319BDE8BGI136D6432E8GA917IF4C285')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '86B13957D457HF21931IC5746BH4E73I8216C16245GH92897FAD35I43F85G216BA97D538H57C12I4F')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '8G42F1CE95B9G4368A631I5H24GEC8492G1696B317H5D174EHF39298512G6D3276D35A9H4AC8697B5')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " 'D79E36A8BF38192D7521E4HG93F21C8I56475H67143B97D93F2851I2D36H75A86A25G94CE73A946B8')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " 'H3E421G69D19F57382267938A4E6ID15837B8G12IC5463526748IA5D32879A616HICE724G29D16E8C')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '9E37D68BAD6712HI531BH53I76DA78F92E345348GA29FBI634581728G31I4653496H57A2FE14G2983')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 23,".
    " 'C72968D158FE4712C919DE3B8677IC241856652I83A4G4H16G59235BI6H713431652D79874HC19B5F')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 29,".
    " 'B13I5DFG8875F32I14D69A87C2E14B5C67H93E94H71B66G82I154382G4FE39A54A79C26H93FH1275D')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '21E67439H83D1IB7F569G583B4ADB7589A36658C1G429A39426H7EID27538F1571BH69433F89147E2')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '9FD3A27E8851I67C4B23G8D59F152348A69GDIH675213176C2IE84136H79B45E2D13F78979845BF1C')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " 'D72EC1698C56G98DABH91B46537314HFE72982E9746CAG6I1234581DF25G983583169BDG9G2CH46A5')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " '476AH2935B5C49768A1985C6GBDEA37I8B64746532H1928IDFA35G82IF4135G1G53B89F4F43I75H12')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " '169E37HB425G68D93A8C41I27F59AE64827C3F8GI24A5247C5A68IDHA7I2356E26H431G997351FD28')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '1749H53BF3FI72154H2E84631I783256A49GI15DG3B86F7DI82C15613G48B5IHED19263772953F84A')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " '1B95D87C687CF914BE5FD32G198IAEB74F83B87C56I144C68A92G535B46A8977FH5391D2I41782F53')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '46I275AHCHE2193F74173DF8E92ED1397H2628G51643I639HBDG156CD7A2958728945CF195A3HF247')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " 'BC1E769D8I86C4AB75547829F3A862CAG495A9D528637G53964B1H7B46531HI8E37194F2196DHBC75')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " '9HF5274C15731F4IH22148CI5G6GD2698153619BCE74H38574A6IBB1EC79864897D56C2AD63A2H9E7')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " 'GHE2493614B31FG598691583D7B6241578IC735HD9216IA83267E4E36I12DG8IH2F74C51147HCEB69')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " 'F1DB8C95757C49F28A289G51D36GI1H45C2FC52I6714864H31B9755F94381G27AD6B58398B31I75F4')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " 'F4785A39B5127936HDC8ID62517964285AG3271ICF845HEC741296519D26G38CBHA574696G4I381BE')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " 'CE6H2714982I1CD567714F95BH35A3798264248FEC9G1976DB1CEH93567B48A412C85G96HFG149532')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " 'A5IDGFC828F73921DE24C15869G698GA3524513624I7HGBD9H53619378412FE45FB3I781HA257643I')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '1462573HI8G94C6521E2CAH97D6G21893D6EF84A5B397CIE674812578IAB634BDC765I189614382EG')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '2C17D56987849163EB5I63H21G4DE9H62A73A23E79F4H86743AB5991F32G5H44C58F12IG72H94E613')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " '2I3584AG61HD72635I7659CA824967H3ED122A34I78F5E48F1BC7974AC59F2HE38F429712I61H7DE3')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 30,".
    " '167I3EH24ECDH62197982741CFE5DF283GA92A9DG63H5837AE94B63GA69245H65874C92A294E1HF7C')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '918D327E63G29EF14H5F48G13928BC174569561B39G8D74968E12CF45BIG38A8236A5D9GIAG438B56')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '761B5I38DB34H175968956D31G2IAC642H754829G51F3E67C81I24DB6598AC7C5H72A64I71ID3F258')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " 'I7231HF45CD52IF8A76A85D79B328F75A49CE34689G21791D32H65EC98641B747B15C96H18F27I354')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " 'E387I6B4164G12H95C2IADCE876AH5972364739EF4281642318IEG41I6ECH2GH76D1B395523G89A64')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 22,".
    " 'H7AE924636D31875I2259C46H1G6BD98531737946A82E5817C29F47561D92C8234G58IA6A9H623D75')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '8F42A7C5IEG1CI8462392D6E817G9F43258AH3D15972F2517H69C49BC145678617283IDE548F7IA23')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " 'G361IE2D8H2A43697E594B78C16E24H6G319C97154BF8HF19237D5952FGA4836DC5897A218G4C26EI')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " 'A5H92D367623187EDI49G5FC812492836GA57AF49523H385BG16492715D3FHI8549FAC72IC6728154')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " 'F1H39247543768E29A25I74A3HF2C48691E71G65D38BIE98127D63521G83I4FG6HI543129CD6A2875')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '89G625ADCF42831G95153D7I68273146BIE858I17C26DBD68953A7589BG6314CA64E8927724I31E6H')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " 'G695812D321843I76E45CB7F18I1EB638497896AG4523734592FA897531D8BFCD268G9E1861IB5CD7')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '273AF4589ADIH52673658739DB143F71589B91G284C65582IFC174C27IE86415IAD3F72884F217C9E')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '73I16B85DE6H39472A42A85793FE41923F788G9416BC5362GH51D92A53974H6983FDB157FG4E18B93')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 23,".
    " '16284EC9GI58G36B1473D12IF58BAI4387568D762E19C563917DH2981673EBD4625H9371CG5241896')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '965A3HB4G32AD5798687D29F35159D38A7BFFC2EG4198G18I62E436EI4728132438A5GFI1876C94B5')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '14596H3GB2793A46E88CF57219D58372A6I416G94C58BBD9658G13D19H36257H25G91D363674B5IHA')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '186257DC9I24H6351753G4IA28F7I53B4HF124A78F35IC6HA5972454391H67BFG8DC2195912F758D3')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '73D812E9F16E79D28C982F5CA47967AB8453842537IA6C1E46972H3HABG9645DB9651C785768342IA')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '9E862A34GFD2E37H9171349H65BGCF289514129CED7H68451F73B9HI247E1F341C26897EE76I3A284')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " 'DEBI36871798415CFBC61G824597956BH14CAC6954H278B41G35I628736IE1D643E8A27I9AE24G638')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '98B7FD5131478C52IFCE6129748H46A79B35713E2DI68BI5H63D1G32G4E169865A389D7B98D67B53A')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 23,".
    " '1934625GH275ACH694FD8579123BE1G34F89847I5F3219C6281DE7327815IDFEA9463782864G9B315')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '72139FHDEH94G5163265C48B7912G3DA96584F95G82ACH15326I74134I6B58798E14732F2F7538AD9')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '954GB1F8383G56429A2FA3897EDH97AFE4321D23796E8F35H42I1724637I5AHG85D16I2319C528476')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " 'D83721E9FG5IH3F1242F15I4738H6EB7913431B6D8IG5I47C1E826F579A83D2D93267EH118B45C679')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '46E89C7211I85B76D3G32F14H5ICH25A4679G14H6I23559627C1D8B48A37I5FC5A9864729674BE381')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '2914EC786357B86IA4HF497123594B53H61GAG8462EI3C56GA9428A75H24C6982963E7416DC19G58B')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '176425ICHDEB38916789316G4258ED31G6922316IH57467954BCAH2DC5897F1915G4F8B37862C1IE4')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '5H71D2963694583ABG1B39F7E48H7E41F32I3F27E9418491C82G56F31258G94B45I7AHC687I63D21E')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " 'D923H6G5A73A94E8266E8BG13I4BCI8146751572F93H4486E3G912EBC1D7968D18F93572769825A4C')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " 'A6D792538293EFH741785341I26915D27FHC6823AI4G5DGC5681922413E9HG6956HB7A348CG6A42E9')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '5G92H64C1D81593BF7F23A74985F9CG5D81B87412I63E51B8CF74IA6H3D5927942716CEH3E72I8461')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '9A78F35B4468I2E1CG32E417FI875H64I132B94813G5F1C67528D9D75C96B813H25716D9961B84E7C')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 29,".
    " '92C41675HDE78B361I81F97E43BC85A7DF9B29F53HG4A1D72F95H3HF92D1E37A72365I84C54G98621')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '64CI7A528981523FGD2E74FH1931CBH6D795H46759A3BE79C2A684289317DE6415BFH397GCF945812')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '274ACF985IF1852C7483E97461BD59623HA763H1DG529G21589CD63917F8EDBBH641579345G2I31F8')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 23,".
    " 'E39741H268B1FC57946D72983E167C19845B9E8DF2317124735H6I2A49H53F7583276ADII7FD13582')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 22,".
    " '2369H14G58DE37269117I46E32H697E2DC18BA8G394565C48167I2A6B75384958792D1FC943F81B57')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '284CEG691359162GDHAF74895239B67C54A847582AF93C1H694G5B873E6I1429162345HGBDE871I36')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " 'H73E21DI6945H67C21AF24I375818GC4I6524E92G61H3326H15ID77C52F491869D718E3B28A5C967D')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '5362DG98187916E2DC4BA893765DI5872AF3316IE47H2B87316E497593B8FAD421F9G5386CH154972')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '3A42IG586B56813D97H79F54C126GE12H94334257I16H1984365BGD52H39761GHA6B59349F37D128E')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " 'C19H4B657642573IA8HGE1964322H69G41C5GE936AHB43DA2E87F9498763E2A1CFB85497527I1D683')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 30,".
    " 'F58372I1413946EHG2BD7I18E634C67H91B5I81B56G4CG2E13D89F84A59G26CCB76A45I86593H2DG1')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '4G32I61H5EF83A49B71IB5G8346I61C5D728G3E286A49B8D71I63E61GE4B83949B87C651H53961D27')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '839AEFB74BD17386595764B93HACF14I578247B18F39E895G3216D91G64352HHF4527I13253IA8F47')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '6HG2A93D52AEH43976D93675B81D53I268717B9581C6DAFH34752919B5FH7344371926EH8EF7CD912')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '462A9EC8751I38724F3GH6425I157423F81I9238G16EDHA6954237GB8651943A95D38G62D6372I1HE')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 29,".
    " '84C5GF91B96E18273D721IC4F853E86B47I14AG3I8EB629615G34H265D39A87HG3F512494AI8GB5F3')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '9FD18352G857BI463121C67E98D4912CF758EBH719346367548AB9679H42C15A8E9FC472432G51HI6')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '41B93F78E93GAEH426E68274A3I569A27C48841FI35727B34H59168E32G469121936E7HDF4G89A352')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '82496C7EAE3FH17I42G19D52H364I63H75A23582F14G91B75I468C179B45F3862E78C19D3DH96A27E')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " 'I75H643A28BC915764641G32E9H2D17C86E9C7FD5I1828E92A64G348352GA9F2IG6315481659HD327')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '9E381BG6D7BHI4F513F1D357982295648CGA3FD2718951G85IC2D6126EHG4394E7639AH28CI421765')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '68A7EB493359F84GB14GB1C956H27H53F914A938425G6F54IA7283H27169CDE91E43726H3468B579A')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " '3B7451H6IA5F389724498GFB3517325IFA485I18D7263HD612CE79FHD91C27E91E47BF3H23768E9A4')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '4582761CII32A85764F1GI432856DB5AC9873G86B95D1591874C2F364G95H2189G21F4ECAE2D3H769')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " '8635GIA4B152C4F8IG97D8125634CA92875626571CDHI789F4E231F14C95B87E28F71I34CI74B8AE6')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 23,".
    " '571C69D82I6D72813528345A9FG8167C49BE5DG69238AC29H15674F5H1I3247479BE6H13132748EI6')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " 'G8A46I23E694325GH1523G819648521D36I791C27F45847F89E31BE16974CB8HD7A32E692CI6E81D7')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '72F1H39E49486G51CB35A4IB687HGA435692C94261EH72658GI134E49C18B67H1FG29453G23ED6918')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " '9E26D1837A43H57F2I7689BC1E4AHID63B75765I8BC14342571H9F32459F71H5G84CA296F1I287D3E')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 30,".
    " '57A62C94HHF4971523923ED8G61G39D56H124AE28GF3I6HB1C94EG3F41I52877I8C42AE6B1EH76394')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " 'IAE368742438BAG965F72549H1C13I8BD657E4F17389272896EDCA2834G1E9F654CHI721AIG2E6384')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '587926A436I1D7C5H23428A59G63E14I86GB82635G91DD97F21E3873D2FI81EA65G38B492HI15D763')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " '5BD16HG9C1CI72456H7H69E31D2C89F41275FEGC92D8142AE78F3I9A74368E22D38159G6865B9G314')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '598FG2C14B4FI13H75371D58B6I1597268DC3F84EI127G4B813596265I87431G8163D5929C4125FHG')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " '361DG2H598E43697ABG29H51D63A4CI276H52756CH94A98F5AD37B5CF7I4218D27186E931I82C56D7')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " '794A865BCFHC92E714E12G34968B5IDA8367HD63972513716254HI87264EI3A5CIA7B46814F8IC2E7')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '3G98D25AF14H76E9236B5IC18D746128E79C582C79FA43GID16258A54F38I27BI64E78C1783A9B564')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " 'D71E93B68C8E216D97296HG45A39857346AB1FC52H749427IF135835F84G12I8G29E16341DI63B78E')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '642C19H57A9H754F32G35B6841998D23576A5134GF8B9F7B98AC5D1IF5B34G834E98G2FA8271D65I3')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '586739BAD421HEF397G9C12468E8729D13F56AE28397D4395G6BA8458A97F2CG3B568149I6AC4B857')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '2D87C5916AEI648732763I12H45H72F94A53E632H1D9G49A53G28F46I32G5813G58149BF1B86E93G4')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '16H29G34E5CGHD629192D3AE86G9867524AC315FHD729DG2193658F7IE24831458163I7B2C1GH9546')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '6C21G89DE4853BI617A794568C278IC5A426BFD97815331526DG9H897B13EFD5DA8967C2F23E4G981')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " 'F35912D878294CG65AD17E683BI5B48G3169G83IA65426912547HC25A74HC9F3ID1652788769CB14E')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " 'B47C69H513EF78149BH91D25G6318FI3D5GB534B67HA927I15834F7A5DI362892C6781DE6H45A29C7')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '5839ADFB74A26G5839G69B38D518CA2564797569HD1239243175HFC48GF5192E91B48C67672AI38D5')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '135HFIB749D817B56C76234E1HI7H36924EAD5I381726216EG4H93IAF3485278C5297F1D42G6EA938')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " 'FIEH72431873FAD25I2415936GHG5D163928128497CF59368EB417E1F3HG2499C25D67HAG84A29C65')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " 'H5F23174I734E98B6A129D67C853951H46B714267ICHE6G8532914568D73I1B4AG9B68532IC85A746')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " 'BGFC4H159145I27C68893651GD2824IFC71559F71B83DCA75842F95IG48B63A4H36G12E912F93E47H')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '1F35G894278B4693AE4E9BC18F7B59D3A786F3HBE719417D98652C62G8ID31E8DA5G3926395F12G48')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 30,".
    " '23I56G14H4F82319E75A7DIH32F6837I2DAE5A9H4F372GDB1C568995ACB487668379EA2DBG4H61953')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '62D93H15G9137E42H6G8E6B1ID3812D95C7636GH2A54IEI43G62185H37412FIAGB695438469H3B157')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '194E67B38F5GH2314932H4AI76EDG68539B123E4IA78F891F72E3464I31E7825G29683AD1HCBD7956')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '7C65918B4589DB3A6721D8FG95367H45I213BI53G1846431F82E79CF7142I8E95263H71D1D87I53B6')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " 'E6B749183149CFH2753G85126DII2F354871534H1G926187296DEC4I52C76A8682DI17E3G3AH659B4')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " 'A92C46758DGE2A8963386I57BD183127E4FIF5D39182G79BDFH1359A7EHC624E3F742A898246195GC')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " 'AC6527D898574I3AB6D29F1837EGI12638543859GDB6A2465H19C794B61E37HEAH7326497F389D15B')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '3B67ED18987A69354B549H12G3F56HICG4123B41F87E91I72E43F8FD1B73895285I16D3G97348E62A')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 29,".
    " '6H3I425G1451FC7H29B97518DC6AFG498C25E43216GI88297EC16475F23I81D98B17DC6E3D16HE9G2')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " '7865BC19DI5D71F382A32D89FG526E4C1H791G85B94F33947FH52A317IE8642B95647H3AHDF213I57')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 30,".
    " 'ID7613H25BHE4GI1F313F25H9GD4HB7913EF63185D927E97C6284A57813I2FDC16G4B5984BI6H5713')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '41953FGH2CBG981654685D27A39AE48976B3H76AC2D9529C54F71H965B7H34A2485137FICGA9F4852')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " 'D1G256389F53HI7124892431FE796E172H4CGD2938561318EFD2G96I8GB45C127E31F48IADC9H5726')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 23,".
    " '6127DC958GE92684A34C81956B7HB4379E6169E82137D71354FB8I18F4952CG532AH7946IGD362851')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '162E78C9D837I4BE61DI5C617828A5BC76496G94582A323491FEGH72A48F9533HD79E126659123HDG')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '7F94132EH1ED86B937823G5I461597A82F3DC26D95G81AH46C7295921876CDE6G354I21H54H31B976')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " '357I84FA2B89E1F7431D67B35I8G38D29EF14E16C78I226I85A374896AGC24E17E92436HD32F8E9A7')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " 'AH35942F775I23F18D246AG83E985631B74IC42897E6191G56D8BCFB1DC89759736254AHD85G91F32')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '729H6E43115C2748FIDF89C1275B7CI5618D6914BH5378E4713FI26I23A7ED8C45982G1618G5D63BI')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 30,".
    " '6C27I58415G18F42I3D89CBAE7615CDBF9GHD8BG59C16IF71382D5269317E8DA3H6459277548IB61C')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " 'G5H31I24F3962DG1H5A2D865C79DG3H921659614538GB25HF1G9435CA6B4987728E3IF144I67815C2')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '4A8793BFE623AEH974G5I4621386CG9425812915HF34G845C17IBF876ABI354DA2835G69593674BH1')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '56483I2GAI215764H378CA4BE96942CH6715CE87A2649617954B3HDI7158F2386523G19D321DF98G5')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " '3A59D72F87HF3E29A42DI6H1573GI4A26H5353A8DG26I82F93E41G4H9671E3BF73D25198A52C98764')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '436718BIE89AB5F74325G34I16HI2A567H43D35A8B6G97H69345B13H96721ED567CA4928D12895F73')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '68E79D23A9412365HGB3GE8A6499B35D61G8618C7ID5BGE4812963H52419C671I3GF582447F3281I5')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " 'G32FI418519F835BDG4587A2369476I5A82C523D78F19IH1B365743685AI2D7IEB7643H114G82C69E')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '14F72I38E2738569DAHEI41C67BD63971H52E92F38DA7187EB43962185C7F943691247HEGDEI68231')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '72H43F1593645A9G821592G83D68I25A36D74EC678921617D9BE8CIG528436124F1C78IE831I6E7B4')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " '63IBEA4788GB94315F14E768C2I196582G4CE38DA76294GB6935H13F7924HAE28ECF1794I1D85G236')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " 'F78B15394392674HAEA5D83I7267DF58I123281DCG5695936124GHHCA4679E27B6I531DH945B8A367')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '7C92465H1814IEG32FB56318GI465G49C81B1HI26E4734231H7IF5375A68I24F91G4253H84BE3I67A')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '943EB7A865H2631GI4AFG948352D396527AHBGF14835981EG3I6243712FD8959258174FCDH65I3271')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '2C54768IA46IE8A73B1783B96ED7A8F5C924C2E948617496B17H3E387EFB1492561I48G3IDA783562')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " 'E89F23A4G642GA59381C7948BE63GB964851561H27CI44H9C15FG27I62C541848C17I2EF52A8FD793')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " 'I46783EB1825DFA739G3A259846639HAD275B7D953F185A86723I44F8C9G1525I71H2346123D65IHG')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " 'CG1459B864F2HA39G5958F27C4181CF4E927247A39F5H5FI87B1C47385ID162E2A78639D4I62137HE')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 23,".
    " '362HGE4919473615BHAE8942F731489E62CG73I4HB615BF5731894513729F8D876AE42934BI38651G')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " 'C8D7A629519B83E64G675DB9A38FE2947138781B63D5939458AG6B4B1579HF39G6CA8524HE32D6917')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '78F93A2452456G89C193AD2EF8G1G8CE96B45ID16B387C62G48A59D92E17H63H1CD26G595768I3214')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " 'GIAC825D65261943HG8C46EG9126734592AHD1BH63759589B7A46C8641CEI27BGA9486CE395726A4H')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 29,".
    " '57DA2C6983BI786514681945BCG9HBCF57D116G49H23E35D712H6IH56B1743I9G1FD3852DB3E98A76')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '4EA72968C8673D19E29325FH71D1GH3D6295D39G2EA8625689AC47I34812E6767H5942AC125FG3489')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " '432518I6G568GD92C1I7A32F548721HI53D6C8FD271I5495163GH2B746HC1E9F53914H7B8AI257FC4')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '841IFC752CEG284169B961573H46A52384IG972ED1638HDC67952AE2I386A74713495H2F468G1B935')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " '3824F9EGA6D1C57892I57B1HF3425H74319F73IBAF4851D68953G2H17I2D63E56C17H92D42I56C78A')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '8AC9D65275943BG6H176251H39D49126H7CE87B13E46IF354G9821FG4C59182I18246G532E3AH79D6')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " 'C61459B7H75H12C46949B86G13E5DF98C7A23A25G68I47H92D1653627135H9DIH5F4G231C14I28E76')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " 'H49213FG55C27694A8761H4E39B19D35B78F37584FI2A2H69A75C45614B89C7BH3197FE4D7IF53A2H')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '865BCI741G2D561389139H47E2FAHF457C922531I64G89G43HB6E16135GH924847I12FC5BIE463718')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '8E96C71D21D78BE3F96BC4I187EG9DC68521518274ICF236E1I748415B8F973GHC491652962357AH4')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '436I78B1529G4518FCE1H63249G3297F48E1784A35F29A56HBI37458C14B69GID25G63A87F19HC2D5')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 23,".
    " 'BE3146I87I47385B61A8692G35D3GA4958626527A84C9498F3B715FB453H71959C17F82D8712D9EF3')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '5DH3162G9296875A4C317IDB856GCB68195D48A3EI7625692741HCH95423A67634517IBHG21FI8435')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '13B6EI74857I3842FADFH7B1953DH1265973956GC8142372149EHFE27C14H968I3FB54A761D897B3E')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '541BCG896H32619E7D96G5842A3629418GEC1873IE246CD5726H91A85364IGB9637BH451DG2159638')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '253AD7689G49268C511HF953D2G7F58913BD9HCF24517241CGE86947893F5AB1IE472836632EAH79D')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " 'GDC62981551283D76I9681EG4C22EA4379F8348B96A57F79H15B4317FC8B5949B54G16H338D59672A')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " '2GC1865D99564723AHH14IEC62772H9AE364561G34B894CI2861GEF32851D978IE64712C74ACIB5F8')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " 'G45F89312H3B157DI6196BD35875B14769C8743IAH26EHF935247A25D86C197FGA529384938714FBE')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " 'DAC956287987A3BE6D6527H41C9FG514839231962E74H428CIGE6176A8345BI8I3B514G6B4EI7F813')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '578134FBI249HE6371AFC7294588E74I23616B4135IH7391FHG5D2G8FI4C21549C51B76821E8769CD')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 23,".
    " '8D923571FA23G96854F7E84A239IE34F7A2824791H6CE168C527I4581674CI23795HB461DBF913587')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '1783629ED5IB1H47363F4GE91286958A7BDCC1G4298658D2F3E917GB1E3948664HB7A95C593486BGA')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " 'CDE8BF1798G63192EDB19D57386I58D61G32A6B738D95743I2EA6H61D2HG593987543FBA5C26I1874')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '65413I28G231784F9EGIHB56A34398721ED6EB74F93184F15HC92GDG2H13965856942A7C319FGE842')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " 'CH72561D9621D3IH5G4591G8FB3513D72I687F8A9C5D294286E73A69E82473A314IG5286BH7316E9D')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '516DCG82998C25674AD2G81936E2439716HEAF5CB8D797I854F1C2354A98G6BHI2637514671B5DI83')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '5BI4F8173748A2CE9613F75948B25F38G9ADIG42613H58A3ID5267G41H9563265I4CB81GC28671EI4')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " 'D23F15I87198347FBEF57H92431C648G12EI81I562G3D72E94C18F59H14F73BB76I53DH13A42G8569')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '865BGC941942A85F3GC7A96428E1IG4863E22ED7IC816836512D9GE3H729FA44715683BI629ADC758')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " 'A6C527984E49H61B73782I431568DE3I127632765D9AH6A92G85C4638DEI71B7I51824C642A367H9E')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " 'I71H24F3564C79E28ABHE16C4795HCG192461G94F25C86B43E89A716839G4EBI54H26317G3254A896')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 29,".
    " '931B48EF7GH25F13945D67I3AB815D38IG2F87I25F14CFCBD1G8598A24736I5F35918D27974B6EC81')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 23,".
    " '58B76D9314AG2935FH3F9518DG2F47H93215325176H4I98A24E7364E93B817678165DI3BF2CA97854')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " 'EAC79642H7B93845FA864B1E97CI41C7E682H37246IA5E2F19H43783D2F915717245C69H6E97H13DB')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '265G98AC49CD2516H71873F42I5382FD19E7GA5829463946E73HA282C41657I1G6E9BC4845I73H62A')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '319G84F5B84E23F79AG62I15H348D32F51I765G9A34H22914GH35F93H57A4261643B8E7I5B76D9183')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " '9D2FAH37538A75964B75F24C198754861BC9I63E24H17HA2I3GE64D83E2F1971GE498BC66B93G14H5')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " 'FC9GH1E428A24F59G35D7B391F84B7CI5816E31687B49986421G5C96H17DB5315432F79HCGBH95F14')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '612EC4H79378FA9EBDI5D287C6149G18532F8C6GDB195512639D7HIFA7482532579634HA8431BE796')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '467EA3I281I524H6C78BC7964E1391H4B675G2D569C815683A79DBAE42H6739872953D1FF39A74285')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 29,".
    " '498B15F37A53764H2IBFG83954AE7IH2416C61B39G48EC84FA5IG29D13E67H25C82719D67B64IH153')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " 'F57B31984C24I68G519A84G52CF4IE7F38A2237HA95D6F81E2D793128C4I57F47E68B19336I15784B')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 29,".
    " '241I7F58CH6G435I129358BADFGACG6298E4E947836BA286E1D3793I2DA5768156278C4IGDH6I3152')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '6AB384GE9H5D917B363792FE8419754CH2616D81293G5A3B756984A46EB389779C48A56B52869GD1C')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " 'D62GE81939HE2314F71736495HB9AF237584574896A2C2384AEG96H49CB56716127D93EHCEG861I24')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '392586D71G45ACB689A6H49G2356CEH1I24G9B847351F714FE29839537641B82F4H5A3IGH7AC29546')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " 'C5G629H14861743EI2924AEH673486273EIACB5918674719ED63827DBI6E13813I28G45FH6543AB9G')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '9D3H7162582536IAGD71624E38I15I78436B24GIC6E8AH63A52D97416EC7298GIB618D535C89246G1')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '63G2IA5848I45G612351BC84F7I1D38G6925F89BC5417257941HCFC68759D1274B36A95H1IE4B8763')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " 'GE9412FC8H3D967B1E1625HC479CDF28G195189453GB6725F9A8345238749FA6DH391572917BEFC48')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '435H79F1278BF5A9DC691BDC75HEI82617433A6EG4298472839AF532G15D98F169HC7425E84926CA7')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '271E4CH695HF192374934876A2E1B6GI54387DH6C192E59C48B61G6HGC5D912B59817D633D12F97E8')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '62A75I34897C68D12E8D5BCA796413HG52962E8396DA7F7I41B358537A64IHBHF95327D1124I8G56C')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 28,".
    " '34EF7A92812I3856DGGF894B135B89563G14EFDB7189C3A748I25F4I68E71C2738412IEF5BA6I3874')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '387BEAI465619C4BG8ID276851C86I13D57242C785A9FAE72I6834695418GB3842CEG619C7A629485')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '281753D6I3E4IF8721F79AB4C8532G89561D546A7B83991H46325GA72IC8E46D9E617B8C8C65D27IA')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 24,".
    " '19C52467HG42A8F9C5F58G93B14DF7815I32851B9C67432I46758A3867412EI4BI5FH3171G59C2846')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " 'F75H32A943986A4GB51D29E78F39EH2617D3D32HGI561716435B8I48732FEAI95C18724F62A59D37H')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " 'H73AD2956EAB93F847946785C1B398DBE61GF5A379B8D2G48615I3ECI784261468123G9E127F5ID38')");

$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 23,".
    " 'E1B674H39976CAH5D2483IB5A674217I835673E2614HI89F53D71218G963B4EF24A578933E92D8671')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '518296C7DFG238D95134I75A628965GC2HD1DB8516G931739H4BF54EI6B31871678D9BC5H32E17496')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '8IF5G12344152HC6G9B73496E8168594CA2GA34E278I672I61H345DEB718C6996135B74H8C79F41E2')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '5D36I7HB1H9G21D356216H53I4723E48F7194897C16B576A59B38D362AE4I78E4HI73A621G96B84C5')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 29,".
    " '34B57F89A1E9HD23FGG86319E42F24I58G1391E67C284H7C4BA9652H51C9467G96D2HE311C46E7BI8')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " '67C52A849I2AH3D67554HG6I1CB2681IE734ADG2635989538746BAD52IH63177A9C524H6C86D1G295')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " '5BC9GA846F9DB85137187C46I25195FHD7324G63529A82C8719EF4D5GB69318821543G6I693H7A45B')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 26,".
    " '1569GC8428B3A46G5ID7I285F1C639D1H527487295FCA1EB7368943FD291G85918EG4CF2527C68I41')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 27,".
    " 'HC5246917427CI16E8169E87D32124CF9G589FEH74B138G32A56I44G368B59A18B53IG4F95F74A32H')");
$DB->execute( "INSERT INTO {game_sudoku_database}( level, opened, data) VALUES (1, 25,".
    " 'B85G41C69C675I2HA41ID8F352767D12H593183D59BG69EB7364818AG4E693263E92A74H249C78F15')");
